/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.reference;

import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Disposable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Processor;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Subscriber;

class DirectoryListenerRegistration
implements Subscriber<WatchEvent<?>> {
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean acceptingRegistrations = new AtomicBoolean(true);
    private final WatchKey key;
    private final ConcurrentHashMap<Path, Processor<WatchEvent<?>, WatchEvent<?>>> fileListeners = new ConcurrentHashMap();
    private final Executor executor;
    private final Processor<WatchEvent<?>, WatchEvent<?>> dirListeners;

    DirectoryListenerRegistration(WatchKey watchKey, Executor executor) {
        this.key = Objects.requireNonNull(watchKey, "key");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.dirListeners = Processor.create(executor);
    }

    public WatchKey key() {
        return this.key;
    }

    @Override
    public void submit(WatchEvent<?> watchEvent) {
        if (!this.acceptingRegistrations.get()) {
            return;
        }
        Path path2 = (Path)watchEvent.context();
        @Nullable Processor processor2 = this.fileListeners.computeIfPresent(path2, (path, processor) -> processor.closeIfUnsubscribed() ? null : processor);
        this.dirListeners.submit(watchEvent);
        if (processor2 != null) {
            processor2.submit(watchEvent);
        }
    }

    @Override
    public void onClose() {
        this.lock.lock();
        try {
            try {
                this.dirListeners.onClose();
            }
            catch (Exception exception) {
                this.dirListeners.onError(exception);
            }
            this.fileListeners.forEach((path, processor) -> {
                try {
                    processor.onClose();
                }
                catch (Exception exception) {
                    processor.onError(exception);
                }
            });
            this.fileListeners.clear();
            this.key.cancel();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Disposable subscribe(Subscriber<WatchEvent<?>> subscriber) {
        if (!this.acceptingRegistrations.get()) {
            return () -> {};
        }
        this.lock.lock();
        try {
            Disposable disposable = this.dirListeners.subscribe(subscriber);
            return disposable;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Disposable subscribe(Path path2, Subscriber<WatchEvent<?>> subscriber) {
        if (!this.acceptingRegistrations.get()) {
            return () -> {};
        }
        this.lock.lock();
        try {
            Disposable disposable = this.fileListeners.computeIfAbsent(path2, path -> Processor.create(this.executor)).subscribe(subscriber);
            return disposable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasSubscribers() {
        this.lock.lock();
        try {
            boolean bl = this.dirListeners.hasSubscribers() || !this.fileListeners.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DirectoryListenerRegistration)) {
            return false;
        }
        DirectoryListenerRegistration directoryListenerRegistration = (DirectoryListenerRegistration)object;
        return this.key().equals(directoryListenerRegistration.key()) && this.fileListeners.equals(directoryListenerRegistration.fileListeners) && this.dirListeners.equals(directoryListenerRegistration.dirListeners);
    }

    public int hashCode() {
        return Objects.hash(this.key(), this.fileListeners, this.dirListeners);
    }

    public boolean closeIfEmpty() {
        this.lock.lock();
        try {
            if (!this.hasSubscribers()) {
                this.onClose();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }
}

