/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.reference;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.TypeToken;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.NodePath;
import us.ajg0702.queue.libs.sponge.configurate.ScopedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.loader.ConfigurationLoader;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Processor;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Publisher;
import us.ajg0702.queue.libs.sponge.configurate.reference.ConfigurationReference;
import us.ajg0702.queue.libs.sponge.configurate.reference.ValueReference;
import us.ajg0702.queue.libs.sponge.configurate.reference.ValueReferenceImpl;

class ManualConfigurationReference<N extends ScopedConfigurationNode<N>>
implements ConfigurationReference<N> {
    protected volatile @MonotonicNonNull N node;
    private final ConfigurationLoader<? extends N> loader;
    protected final Processor.TransactionalIso<N> updateListener;
    protected final Processor.Iso<Map.Entry<ConfigurationReference.ErrorPhase, Throwable>> errorListener;

    ManualConfigurationReference(ConfigurationLoader<? extends N> configurationLoader, Executor executor) {
        this.loader = configurationLoader;
        this.updateListener = Processor.createTransactional(executor);
        this.errorListener = Processor.create(executor);
        this.errorListener.fallbackHandler(entry -> {
            System.err.println("Unhandled error while performing a " + entry.getKey() + " for a configuration reference: " + entry.getValue());
            ((Throwable)entry.getValue()).printStackTrace();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void load() {
        ConfigurationLoader<? extends N> configurationLoader = this.loader;
        synchronized (configurationLoader) {
            this.node = (ScopedConfigurationNode)this.loader.load();
            this.updateListener.submit(this.node);
        }
    }

    @Override
    public final void save() {
        this.save((ConfigurationNode)this.node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ConfigurationNode configurationNode) {
        Objects.requireNonNull(configurationNode, "newNode");
        ConfigurationLoader<? extends N> configurationLoader = this.loader;
        synchronized (configurationLoader) {
            N n = this.node;
            if (n.getClass().equals(configurationNode.getClass())) {
                this.node = (ScopedConfigurationNode)configurationNode;
                this.loader.save((ConfigurationNode)this.node);
                if (configurationNode != n) {
                    this.updateListener.submit(this.node);
                }
            } else {
                this.loader.save(this.node.from(configurationNode));
                this.updateListener.submit(this.node);
            }
        }
    }

    @Override
    public final Publisher<N> saveAsync() {
        return Publisher.execute(() -> {
            this.save();
            return this.node();
        }, this.updateListener.executor());
    }

    @Override
    public final Publisher<N> updateAsync(Function<N, ? extends N> function) {
        return Publisher.execute(() -> {
            ScopedConfigurationNode scopedConfigurationNode = (ScopedConfigurationNode)function.apply(this.node());
            this.save(scopedConfigurationNode);
            return scopedConfigurationNode;
        }, this.updateListener.executor());
    }

    @Override
    public final N node() {
        return this.node;
    }

    @Override
    public final ConfigurationLoader<? extends N> loader() {
        return this.loader;
    }

    @Override
    public final N get(Object ... objectArray) {
        return (N)this.node().node(objectArray);
    }

    @Override
    public final N get(Iterable<?> iterable) {
        return (N)this.node().node((Iterable)iterable);
    }

    @Override
    public final <T> ValueReference<T, N> referenceTo(TypeToken<T> typeToken, NodePath nodePath, @Nullable T t) {
        return new ValueReferenceImpl(this, nodePath, typeToken, t);
    }

    @Override
    public final <T> ValueReference<T, N> referenceTo(Class<T> clazz, NodePath nodePath, @Nullable T t) {
        return new ValueReferenceImpl(this, nodePath, clazz, t);
    }

    @Override
    public final Publisher<N> updates() {
        return this.updateListener;
    }

    @Override
    public final Publisher<Map.Entry<ConfigurationReference.ErrorPhase, Throwable>> errors() {
        return this.errorListener;
    }

    @Override
    public void close() {
        this.updateListener.onClose();
    }
}

