/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.reference;

import java.util.concurrent.Executor;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.TypeToken;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.NodePath;
import us.ajg0702.queue.libs.sponge.configurate.ScopedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Disposable;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Publisher;
import us.ajg0702.queue.libs.sponge.configurate.reactive.Subscriber;
import us.ajg0702.queue.libs.sponge.configurate.reactive.TransactionFailedException;
import us.ajg0702.queue.libs.sponge.configurate.reference.ConfigurationReference;
import us.ajg0702.queue.libs.sponge.configurate.reference.ManualConfigurationReference;
import us.ajg0702.queue.libs.sponge.configurate.reference.ValueReference;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;
import us.ajg0702.queue.libs.sponge.configurate.util.UnmodifiableCollections;

class ValueReferenceImpl<@Nullable T, N extends ScopedConfigurationNode<N>>
implements ValueReference<T, N>,
Publisher<T> {
    private final ManualConfigurationReference<N> root;
    private final NodePath path;
    private final TypeToken<T> type;
    private final TypeSerializer<T> serializer;
    private final Publisher.Cached<@Nullable T> deserialized;

    ValueReferenceImpl(ManualConfigurationReference<N> manualConfigurationReference, NodePath nodePath, TypeToken<T> typeToken, @Nullable T t) {
        this.root = manualConfigurationReference;
        this.path = nodePath;
        this.type = typeToken;
        @Nullable TypeSerializer<T> typeSerializer = manualConfigurationReference.node().options().serializers().get(typeToken);
        if (typeSerializer == null) {
            throw new SerializationException(this.path, typeToken.getType(), "Unsupported type" + typeToken);
        }
        this.serializer = typeSerializer;
        this.deserialized = manualConfigurationReference.updateListener.map((I scopedConfigurationNode) -> {
            try {
                return this.deserializedValueFrom(scopedConfigurationNode, t);
            }
            catch (SerializationException serializationException) {
                manualConfigurationReference.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.VALUE, serializationException));
                throw new TransactionFailedException(serializationException);
            }
        }).cache(this.deserializedValueFrom(manualConfigurationReference.node(), t));
    }

    ValueReferenceImpl(ManualConfigurationReference<N> manualConfigurationReference, NodePath nodePath, Class<T> clazz, @Nullable T t) {
        this(manualConfigurationReference, nodePath, TypeToken.get(clazz), t);
    }

    private @Nullable T deserializedValueFrom(N n, @Nullable T t) {
        T t2;
        ConfigurationNode configurationNode = n.node((Iterable)this.path);
        if (!configurationNode.virtual()) {
            return this.serializer.deserialize(this.type.getType(), configurationNode);
        }
        T t3 = t2 = t == null ? this.serializer.emptyValue(this.type.getType(), configurationNode.options()) : t;
        if (configurationNode.options().shouldCopyDefaults()) {
            this.serializer.serialize(this.type.getType(), t2, configurationNode);
        }
        return t2;
    }

    @Override
    public @Nullable T get() {
        return this.deserialized.get();
    }

    @Override
    public boolean set(@Nullable T t) {
        try {
            this.serializer.serialize(this.type.getType(), t, this.node());
            this.deserialized.submit(t);
            return true;
        }
        catch (SerializationException serializationException) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.SAVING, serializationException));
            return false;
        }
    }

    @Override
    public boolean setAndSave(@Nullable T t) {
        try {
            if (this.set(t)) {
                this.root.save();
                return true;
            }
        }
        catch (ConfigurateException configurateException) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.SAVING, configurateException));
        }
        return false;
    }

    @Override
    public Publisher<Boolean> setAndSaveAsync(@Nullable T t) {
        return Publisher.execute(() -> {
            this.serializer.serialize(this.type.getType(), t, this.node());
            this.deserialized.submit(t);
            this.root.save();
            return true;
        }, this.root.updates().executor());
    }

    @Override
    public boolean update(Function<@Nullable T, ? extends T> function) {
        try {
            return this.set(function.apply(this.get()));
        }
        catch (Exception exception) {
            this.root.errorListener.submit(UnmodifiableCollections.immutableMapEntry(ConfigurationReference.ErrorPhase.VALUE, exception));
            return false;
        }
    }

    @Override
    public Publisher<Boolean> updateAsync(Function<@Nullable T, ? extends T> function) {
        return Publisher.execute(() -> {
            @Nullable T t = this.get();
            Object r = function.apply(t);
            this.serializer.serialize(this.type.getType(), r, this.node());
            this.deserialized.submit(r);
            this.root.save();
            return true;
        }, this.root.updates().executor());
    }

    @Override
    public N node() {
        return (N)this.root.node().node((Iterable)this.path);
    }

    @Override
    public Disposable subscribe(Subscriber<? super T> subscriber) {
        return this.deserialized.subscribe(subscriber);
    }

    @Override
    public boolean hasSubscribers() {
        return this.deserialized.hasSubscribers();
    }

    @Override
    public Executor executor() {
        return this.deserialized.executor();
    }
}

