/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import us.ajg0702.queue.libs.sponge.configurate.serialize.CoercionFailedException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.ScalarSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;

final class CharSerializer
extends ScalarSerializer<Character> {
    CharSerializer() {
        super(Character.class);
    }

    @Override
    public Character deserialize(Type type, Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            throw new SerializationException(type, "Only single character expected, but received " + string);
        }
        if (object instanceof Number) {
            return Character.valueOf((char)((Number)object).shortValue());
        }
        throw new CoercionFailedException(type, object, "char");
    }

    @Override
    public Object serialize(@NonNull Character c, Predicate<Class<?>> predicate) {
        if (predicate.test(Character.TYPE)) {
            return c;
        }
        return c.toString();
    }
}

