/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import us.ajg0702.queue.libs.sponge.configurate.serialize.ScalarSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedFunction;

final class FunctionScalarSerializer<T>
extends ScalarSerializer<T> {
    private final CheckedFunction<Object, T, SerializationException> deserializer;
    private final BiFunction<T, Predicate<Class<?>>, Object> serializer;

    FunctionScalarSerializer(Type type, CheckedFunction<Object, T, SerializationException> checkedFunction, BiFunction<T, Predicate<Class<?>>, Object> biFunction) {
        super(type);
        this.deserializer = checkedFunction;
        this.serializer = biFunction;
    }

    @Override
    public T deserialize(Type type, Object object) {
        try {
            return this.deserializer.apply(object);
        }
        catch (SerializationException serializationException) {
            serializationException.initType(type);
            throw serializationException;
        }
    }

    @Override
    public Object serialize(T t, Predicate<Class<?>> predicate) {
        return this.serializer.apply(t, predicate);
    }
}

