/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.TypeToken;
import us.ajg0702.queue.libs.sponge.configurate.serialize.AbstractListChildSerializer;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.util.CheckedConsumer;

final class ListSerializer
extends AbstractListChildSerializer<List<?>> {
    static final TypeToken<List<?>> TYPE = new TypeToken<List<?>>(){};

    ListSerializer() {
    }

    @Override
    protected Type elementType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException(type, "Raw types are not supported for collections");
        }
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }

    @Override
    protected List<?> createNew(int n, Type type) {
        return new ArrayList(n);
    }

    @Override
    protected void forEachElement(List<?> list, CheckedConsumer<Object, SerializationException> checkedConsumer) {
        for (Object obj : list) {
            checkedConsumer.accept(obj);
        }
    }

    @Override
    protected void deserializeSingle(int n, List<?> list, @Nullable Object object) {
        list.add(object);
    }
}

