/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.serialize;

import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.serialize.TypeSerializer;

final class PathSerializer
implements TypeSerializer<Path> {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final PathSerializer INSTANCE = new PathSerializer();
    static final Class<Path> TYPE = Path.class;

    private PathSerializer() {
    }

    @Override
    public Path deserialize(Type type, ConfigurationNode configurationNode) {
        if (configurationNode.isList()) {
            @Nullable List<String> list = configurationNode.getList(String.class);
            if (list == null || list.isEmpty()) {
                return Paths.get(".", new String[0]);
            }
            if (list.size() == 1) {
                return Paths.get(list.get(0), new String[0]);
            }
            return Paths.get(list.get(0), list.subList(1, list.size()).toArray(EMPTY_STRING_ARRAY));
        }
        if (configurationNode.isMap()) {
            throw new SerializationException("Paths must be a list of strings, or a single string");
        }
        @Nullable Object object = configurationNode.rawScalar();
        if (object == null) {
            throw new SerializationException("must have scalar value");
        }
        if (object instanceof URI) {
            return Paths.get((URI)object);
        }
        return Paths.get(object.toString(), new String[0]);
    }

    @Override
    public void serialize(Type type, @Nullable Path path, ConfigurationNode configurationNode) {
        if (path == null) {
            configurationNode.set(null);
            return;
        }
        if (configurationNode.isList()) {
            configurationNode.set(null);
            for (Path path2 : path) {
                configurationNode.appendListNode().set(path2.toString());
            }
        } else if (!path.getFileSystem().equals(FileSystems.getDefault())) {
            configurationNode.set(URI.class, path.toUri());
        } else {
            configurationNode.raw(path.toString());
        }
    }
}

