/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.transformation;

import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurateException;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.NodePath;
import us.ajg0702.queue.libs.sponge.configurate.transformation.ChainedConfigurationTransformation;
import us.ajg0702.queue.libs.sponge.configurate.transformation.MoveStrategy;
import us.ajg0702.queue.libs.sponge.configurate.transformation.NodePathComparator;
import us.ajg0702.queue.libs.sponge.configurate.transformation.SingleConfigurationTransformation;
import us.ajg0702.queue.libs.sponge.configurate.transformation.TransformAction;
import us.ajg0702.queue.libs.sponge.configurate.transformation.VersionedTransformation;

@FunctionalInterface
public interface ConfigurationTransformation {
    public static final Object WILDCARD_OBJECT = new Object();

    public static ConfigurationTransformation empty() {
        return node -> {};
    }

    public static Builder builder() {
        return new Builder();
    }

    public static VersionedBuilder versionedBuilder() {
        return new VersionedBuilder();
    }

    public static ConfigurationTransformation chain(ConfigurationTransformation ... transformations) {
        if (Objects.requireNonNull(transformations, "transformations").length == 0) {
            throw new IllegalArgumentException("Cannot chain an empty array of transformations!");
        }
        if (transformations.length == 1) {
            return transformations[0];
        }
        return new ChainedConfigurationTransformation(transformations);
    }

    public void apply(ConfigurationNode var1) throws ConfigurateException;

    public static interface Versioned
    extends ConfigurationTransformation {
        public static final int VERSION_UNKNOWN = -1;

        public NodePath versionKey();

        public int latestVersion();

        default public int version(ConfigurationNode node) {
            return node.node(this.versionKey()).getInt(-1);
        }
    }

    public static final class VersionedBuilder {
        private NodePath versionKey = NodePath.path("version");
        private final NavigableMap<Integer, ConfigurationTransformation> versions = new TreeMap<Integer, ConfigurationTransformation>();

        VersionedBuilder() {
        }

        public VersionedBuilder versionKey(Object ... objectArray) {
            this.versionKey = NodePath.of(objectArray);
            return this;
        }

        public @NonNull VersionedBuilder addVersion(int n, @NonNull ConfigurationTransformation configurationTransformation) {
            if (n < 0) {
                throw new IllegalArgumentException("Version must be at least 0");
            }
            if (this.versions.putIfAbsent(n, Objects.requireNonNull(configurationTransformation, "transformation")) != null) {
                throw new IllegalArgumentException("Version '" + n + "' has been specified multiple times.");
            }
            return this;
        }

        public @NonNull VersionedBuilder addVersion(int n, ConfigurationTransformation ... configurationTransformationArray) {
            return this.addVersion(n, ConfigurationTransformation.chain(configurationTransformationArray));
        }

        public @NonNull VersionedBuilder makeVersion(int n, @NonNull Consumer<? super Builder> consumer) {
            Builder builder = ConfigurationTransformation.builder();
            consumer.accept(builder);
            return this.addVersion(n, builder.build());
        }

        public @NonNull Versioned build() {
            if (this.versions.isEmpty()) {
                throw new IllegalArgumentException("At least one version must be specified to build a transformation");
            }
            return new VersionedTransformation(this.versionKey, this.versions);
        }
    }

    public static final class Builder {
        private MoveStrategy strategy = MoveStrategy.OVERWRITE;
        private final NavigableMap<NodePath, TransformAction> actions = new TreeMap<NodePath, TransformAction>(NodePathComparator.INSTANCE);

        Builder() {
        }

        public Builder addAction(NodePath nodePath, TransformAction transformAction) {
            this.actions.put(Objects.requireNonNull(nodePath, "path"), Objects.requireNonNull(transformAction, "action"));
            return this;
        }

        public MoveStrategy moveStrategy() {
            return this.strategy;
        }

        public Builder moveStrategy(MoveStrategy moveStrategy) {
            this.strategy = Objects.requireNonNull(moveStrategy, "strategy");
            return this;
        }

        public ConfigurationTransformation build() {
            if (this.actions.isEmpty()) {
                throw new IllegalArgumentException("At least one action must be specified to build a transformation");
            }
            return new SingleConfigurationTransformation(this.actions, this.strategy);
        }
    }
}

