/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.sponge.configurate.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.Nullable;
import us.ajg0702.queue.libs.geantyref.GenericTypeReflector;
import us.ajg0702.queue.libs.geantyref.TypeFactory;
import us.ajg0702.queue.libs.geantyref.TypeToken;
import us.ajg0702.queue.libs.sponge.configurate.util.UnmodifiableCollections;

public final class Types {
    private static final Map<Type, Type> BOXED_TO_PRIMITIVE = UnmodifiableCollections.buildMap(map -> {
        map.put(Boolean.class, Boolean.TYPE);
        map.put(Character.class, Character.TYPE);
        map.put(Byte.class, Byte.TYPE);
        map.put(Short.class, Short.TYPE);
        map.put(Integer.class, Integer.TYPE);
        map.put(Long.class, Long.TYPE);
        map.put(Float.class, Float.TYPE);
        map.put(Double.class, Double.TYPE);
        map.put(Void.class, Void.TYPE);
    });
    private static final Map<Type, Type> PRIMITIVE_TO_BOXED = UnmodifiableCollections.buildMap(map -> {
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Character.TYPE, Character.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        map.put(Void.TYPE, Void.class);
    });

    private Types() {
    }

    public static boolean isArray(Type type) {
        if (type instanceof Class) {
            return ((Class)type).isArray();
        }
        if (type instanceof ParameterizedType) {
            return Types.isArray(((ParameterizedType)type).getRawType());
        }
        return type instanceof GenericArrayType;
    }

    public static boolean isBoxedPrimitive(Type type) {
        return BOXED_TO_PRIMITIVE.containsKey(type);
    }

    public static Type unbox(Type type) {
        Type type2 = BOXED_TO_PRIMITIVE.get(type);
        return type2 == null ? type : type2;
    }

    public static @Nullable Object defaultValue(Class<?> clazz) {
        Objects.requireNonNull(clazz, "type");
        if (!clazz.isPrimitive() || clazz == Void.TYPE) {
            return null;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        return Array.get(Array.newInstance(clazz, 1), 0);
    }

    public static Type box(Type type) {
        Type type2 = PRIMITIVE_TO_BOXED.get(type);
        return type2 == null ? type : type2;
    }

    public static <T> TypeToken<List<T>> makeListType(TypeToken<T> typeToken) {
        return TypeToken.get(TypeFactory.parameterizedClass(List.class, typeToken.getType()));
    }

    public static AnnotatedElement combinedAnnotations(AnnotatedElement ... annotatedElementArray) {
        return new CombinedAnnotations(Arrays.copyOf(annotatedElementArray, annotatedElementArray.length));
    }

    public static Type requireCompleteParameters(Type type) {
        if (GenericTypeReflector.isMissingTypeParameters(type)) {
            throw new IllegalArgumentException("Provided type " + type + " is a raw type, which is not accepted.");
        }
        return type;
    }

    public static Stream<Type> allSuperTypes(Type type) {
        return Types.calculateSuperTypes(type, false);
    }

    public static Stream<Type> allSuperTypesAndInterfaces(Type type) {
        return Types.calculateSuperTypes(type, true);
    }

    private static Stream<Type> calculateSuperTypes(Type type, boolean bl) {
        Objects.requireNonNull(type, "type");
        return StreamSupport.stream(Spliterators.spliterator(new SuperTypesIterator(type, bl), Long.MAX_VALUE, 1280), false);
    }

    static class CombinedAnnotations
    implements AnnotatedElement {
        private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
        private final AnnotatedElement[] elements;

        CombinedAnnotations(AnnotatedElement[] annotatedElementArray) {
            this.elements = annotatedElementArray;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
            for (AnnotatedElement annotatedElement : this.elements) {
                if (!annotatedElement.isAnnotationPresent(clazz)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends Annotation> @Nullable T getAnnotation(Class<T> clazz) {
            AnnotatedElement annotatedElement;
            @Nullable T t = null;
            AnnotatedElement[] annotatedElementArray = this.elements;
            int n = annotatedElementArray.length;
            for (int i = 0; i < n && (t = (T)(annotatedElement = annotatedElementArray[i]).getAnnotation(clazz)) == null; ++i) {
            }
            return t;
        }

        @Override
        public Annotation[] getAnnotations() {
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
            for (AnnotatedElement annotatedElement : this.elements) {
                Annotation[] annotationArray = annotatedElement.getAnnotations();
                if (annotationArray.length <= 0) continue;
                arrayList.addAll(Arrays.asList(annotationArray));
            }
            return arrayList.toArray(EMPTY_ANNOTATION_ARRAY);
        }

        @Override
        public <T extends Annotation> T[] getAnnotationsByType(Class<T> clazz) {
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
            for (AnnotatedElement annotatedElement : this.elements) {
                Annotation[] annotationArray = annotatedElement.getAnnotationsByType(clazz);
                if (annotationArray.length <= 0) continue;
                arrayList.addAll(Arrays.asList(annotationArray));
            }
            return arrayList.toArray(EMPTY_ANNOTATION_ARRAY);
        }

        @Override
        public <T extends Annotation> @Nullable T getDeclaredAnnotation(Class<T> clazz) {
            AnnotatedElement annotatedElement;
            @Nullable T t = null;
            AnnotatedElement[] annotatedElementArray = this.elements;
            int n = annotatedElementArray.length;
            for (int i = 0; i < n && (t = (T)(annotatedElement = annotatedElementArray[i]).getDeclaredAnnotation(clazz)) == null; ++i) {
            }
            return t;
        }

        @Override
        public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> clazz) {
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
            for (AnnotatedElement annotatedElement : this.elements) {
                Annotation[] annotationArray = annotatedElement.getDeclaredAnnotationsByType(clazz);
                if (annotationArray.length <= 0) continue;
                arrayList.addAll(Arrays.asList(annotationArray));
            }
            return arrayList.toArray(EMPTY_ANNOTATION_ARRAY);
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
            for (AnnotatedElement annotatedElement : this.elements) {
                Annotation[] annotationArray = annotatedElement.getDeclaredAnnotations();
                if (annotationArray.length <= 0) continue;
                arrayList.addAll(Arrays.asList(annotationArray));
            }
            return arrayList.toArray(EMPTY_ANNOTATION_ARRAY);
        }
    }

    static class SuperTypesIterator
    implements Iterator<Type> {
        private final boolean includeInterfaces;
        private final Deque<Type> types = new ArrayDeque<Type>();
        private final Set<Type> seen = new HashSet<Type>();

        SuperTypesIterator(Type type, boolean bl) {
            this.types.add(type);
            this.includeInterfaces = bl;
        }

        @Override
        public boolean hasNext() {
            return !this.types.isEmpty();
        }

        @Override
        public Type next() {
            Type type = this.types.removeLast();
            if (type instanceof Class && ((Class)type).isArray() || type instanceof GenericArrayType) {
                Type type2 = type instanceof Class ? ((Class)type).getComponentType() : ((GenericArrayType)type).getGenericComponentType();
                this.addSuperClassAndInterface(type2, GenericTypeReflector.erase(type2), TypeFactory::arrayOf);
            } else if (type instanceof Class || type instanceof ParameterizedType) {
                Class clazz;
                if (type instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    clazz = (Class)parameterizedType.getRawType();
                } else {
                    clazz = (Class)type;
                }
                this.addSuperClassAndInterface(type, clazz, null);
            } else if (type instanceof TypeVariable) {
                this.addAllIfUnseen(type, ((TypeVariable)type).getBounds());
            } else if (type instanceof WildcardType) {
                Type[] typeArray = ((WildcardType)type).getUpperBounds();
                if (typeArray.length == 1) {
                    Type type3 = typeArray[0];
                    this.addSuperClassAndInterface(type, GenericTypeReflector.erase(type3), TypeFactory::wildcardExtends);
                } else {
                    this.addAllIfUnseen(type, ((WildcardType)type).getUpperBounds());
                }
            }
            return type;
        }

        private void addAllIfUnseen(Type type, Type ... typeArray) {
            for (Type type2 : typeArray) {
                this.addIfUnseen(GenericTypeReflector.resolveType(type2, type));
            }
        }

        private void addIfUnseen(Type type) {
            if (this.seen.add(type)) {
                this.types.addLast(type);
            }
        }

        private void addSuperClassAndInterface(Type type, Class<?> clazz, @Nullable UnaryOperator<Type> unaryOperator) {
            if (this.includeInterfaces) {
                for (Type type2 : clazz.getGenericInterfaces()) {
                    if (unaryOperator != null) {
                        this.addIfUnseen((Type)unaryOperator.apply(GenericTypeReflector.resolveType(type2, type)));
                        continue;
                    }
                    this.addIfUnseen(GenericTypeReflector.resolveType(type2, type));
                }
            }
            if (clazz.getSuperclass() != null) {
                Type type3 = GenericTypeReflector.resolveType(clazz.getGenericSuperclass(), type);
                this.addIfUnseen(unaryOperator == null ? type3 : (Type)unaryOperator.apply(type3));
            }
        }
    }
}

