/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.utils.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import us.ajg0702.queue.libs.sponge.configurate.CommentedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.yaml.NodeStyle;
import us.ajg0702.queue.libs.sponge.configurate.yaml.YamlConfigurationLoader;
import us.ajg0702.queue.libs.utils.common.ConfigInterface;

public class ConfigFile
implements ConfigInterface {
    File f;
    CommentedConfigurationNode config;
    YamlConfigurationLoader loader;
    File pluginFolder;
    Logger logger;
    String nfm;
    private final Class<?> getDefaultFrom;
    String fileName;

    @Override
    public Object get(String string) {
        Object object = null;
        try {
            object = ((CommentedConfigurationNode)this.config.node(string.split("\\."))).get(Object.class);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        if (object == null) {
            this.logger.severe(this.nfm.replace("KEY", string));
        }
        return object;
    }

    @Override
    public Integer getInt(String string) {
        int n = ((CommentedConfigurationNode)this.config.node(string.split("\\."))).getInt(-38964298);
        if (n == -38964298) {
            this.logger.severe(this.nfm.replace("KEY", string));
        }
        return n;
    }

    @Override
    public String getString(String string) {
        String string2 = ((CommentedConfigurationNode)this.config.node(string.split("\\."))).getString();
        if (string2 == null) {
            this.logger.severe(this.nfm.replace("KEY", string));
        }
        return string2;
    }

    @Override
    public List<String> getStringList(String string) {
        List<String> list = null;
        try {
            list = ((CommentedConfigurationNode)this.config.node(string.split("\\."))).getList(String.class);
        }
        catch (SerializationException serializationException) {
            // empty catch block
        }
        if (list == null) {
            this.logger.severe(this.nfm.replace("KEY", string));
        }
        return list;
    }

    @Override
    public boolean getBoolean(String string) {
        return ((CommentedConfigurationNode)this.config.node(string.split("\\."))).getBoolean();
    }

    @Override
    public double getDouble(String string) {
        double d = ((CommentedConfigurationNode)this.config.node(string.split("\\."))).getDouble(-3.8964298E7);
        if (d == -3.8964298E7) {
            this.logger.severe(this.nfm.replace("KEY", string));
        }
        return d;
    }

    public boolean hasEntry(String string) {
        return !((CommentedConfigurationNode)this.config.node(string.split("\\."))).virtual();
    }

    public String getDefaultConfig() {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getDefaultFrom.getResourceAsStream("/" + this.fileName))));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    public String getConfigString() {
        List<String> list = Files.readAllLines(Paths.get(this.pluginFolder.getPath(), this.fileName));
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    public ConfigFile(File file, Logger logger, String string) {
        this(file, logger, string, null);
    }

    public ConfigFile(File file, Logger logger, String string, Class<?> clazz) {
        this.logger = logger;
        this.fileName = string;
        this.getDefaultFrom = clazz == null ? this.getClass() : clazz;
        this.pluginFolder = file;
        this.nfm = "Could not find KEY in " + string + "! Try restarting the server, or deleting " + string + " and allowing the plugin to re-create it.";
        this.f = new File(file, string);
        this.loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(this.f)).nodeStyle(NodeStyle.BLOCK).build();
        if (!this.f.exists()) {
            if (!Files.exists(file.toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectory(file.toPath(), new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            try {
                String[] stringArray;
                PrintWriter printWriter = new PrintWriter(file + File.separator + string, "UTF-8");
                for (String string2 : stringArray = this.getDefaultConfig().split("\n")) {
                    printWriter.println(string2);
                }
                printWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            try {
                this.f = new File(file, string);
                YamlConfigurationLoader yamlConfigurationLoader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(this.f)).nodeStyle(NodeStyle.BLOCK).build();
                CommentedConfigurationNode commentedConfigurationNode = (CommentedConfigurationNode)yamlConfigurationLoader.load();
                String string3 = this.getDefaultConfig();
                int n = ((CommentedConfigurationNode)commentedConfigurationNode.node(new Object[]{"config-version"})).getInt(0);
                String string4 = string3.split("config-version: ")[1].split("\n")[0];
                int n2 = Integer.parseInt(string4);
                if (n < n2) {
                    String[] stringArray;
                    logger.info("Starting config converter!");
                    Date date = Calendar.getInstance().getTime();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
                    String string5 = simpleDateFormat.format(date);
                    ConfigFile.duplicateFile(this.f, new File(file, string + ".old." + string5));
                    String string6 = this.getConfigString();
                    this.f = new File(file, string);
                    this.config = (CommentedConfigurationNode)this.loader.load();
                    logger.info(commentedConfigurationNode.childrenMap().size() + " children");
                    for (Object stringArray2 : commentedConfigurationNode.childrenMap().keySet()) {
                        Object object;
                        String string22;
                        String[] stringArray3 = stringArray2.toString() + ":";
                        logger.info("Key: " + (String)stringArray3);
                        assert (stringArray3 != null);
                        String[] stringArray4 = stringArray3.split("\\.");
                        String string7 = stringArray4[stringArray4.length - 1];
                        logger.info("keySec: " + string7);
                        String string8 = string3.split(string7)[1].split("\n")[0];
                        logger.info("newVal before: " + string8);
                        int n3 = 0;
                        for (String string22 : string3.split(string7)[1].split("\n")) {
                            if (n3 == 0) {
                                ++n3;
                                continue;
                            }
                            ++n3;
                            logger.info("Scanning: " + string22);
                            if (!string22.trim().startsWith("-")) break;
                            string8 = string8 + "\n" + string22;
                        }
                        logger.info("newVal after: " + string8);
                        String string9 = string7 + string8;
                        CommentedConfigurationNode commentedConfigurationNode2 = (CommentedConfigurationNode)commentedConfigurationNode.node(stringArray3.substring(0, stringArray3.length() - 1).split("\\."));
                        Object object2 = commentedConfigurationNode2.get(Object.class);
                        String string10 = string22 = object2 == null ? null : object2.toString();
                        if (commentedConfigurationNode2.isList()) {
                            object = commentedConfigurationNode2.getList(String.class);
                        }
                        logger.info("nodeString: " + string22);
                        if (!commentedConfigurationNode2.isList() && string22 != null && (string22.contains(",") || string22.contains(".") || string22.isEmpty() || string22.contains("?")) && !string22.startsWith("\"") && !string22.startsWith("'")) {
                            string22 = "\"" + string22 + "\"";
                        }
                        if (!((String)(object = string7 + " " + (string22 != null ? string22 : ""))).endsWith("[]")) {
                            object = ((String)object).replaceAll("\\[", "\n- \"");
                            object = ((String)object).replaceAll(", ", "\"\n- \"");
                            object = ((String)object).replaceAll("]", "\"");
                        }
                        if (string7.contains("config-version") || ((String)object).contains("null")) continue;
                        logger.info("Find: " + string9 + " Replace w: " + (String)object);
                        string3 = string3.replaceAll("\\Q" + Matcher.quoteReplacement(string9) + "\\E", Matcher.quoteReplacement((String)object));
                    }
                    PrintWriter printWriter = new PrintWriter(this.f, "UTF-8");
                    for (String string8 : stringArray = string3.split("\n")) {
                        printWriter.println(string8);
                    }
                    printWriter.close();
                }
            }
            catch (IOException iOException) {
                logger.severe("Unable to load default config! " + iOException.getMessage() + "\n" + Arrays.toString(iOException.getStackTrace()));
            }
        }
        this.f = new File(file, string);
        this.config = (CommentedConfigurationNode)this.loader.load();
    }

    @Override
    public void reload() {
        this.config = (CommentedConfigurationNode)this.loader.load();
    }

    public CommentedConfigurationNode getConfig() {
        return this.config;
    }

    public YamlConfigurationLoader getLoader() {
        return this.loader;
    }

    private static void duplicateFile(File file, File file2) {
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            int n;
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
    }
}

