/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.utils.common;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import us.ajg0702.queue.libs.sponge.configurate.CommentedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.ConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.yaml.NodeStyle;
import us.ajg0702.queue.libs.sponge.configurate.yaml.YamlConfigurationLoader;
import us.ajg0702.queue.libs.utils.common.ConfigFile;

public class Messages {
    File msgFile;
    File pluginFolder;
    YamlConfigurationLoader loader;
    ConfigFile config;
    CommentedConfigurationNode msgs;
    Logger logger;
    Map<String, Object> defaultValues;
    Map<String, String> moving;
    private final Random random = new Random();
    private final LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacySection();
    private MiniMessage miniMessage;
    private static final ImmutableMap<String, String> colorReplacements = new ImmutableMap.Builder().put((Object)"0", (Object)"<black>").put((Object)"1", (Object)"<dark_blue>").put((Object)"2", (Object)"<dark_green>").put((Object)"3", (Object)"<dark_aqua>").put((Object)"4", (Object)"<dark_red>").put((Object)"5", (Object)"<dark_purple>").put((Object)"6", (Object)"<gold>").put((Object)"7", (Object)"<gray>").put((Object)"8", (Object)"<dark_gray>").put((Object)"9", (Object)"<blue>").put((Object)"a", (Object)"<green>").put((Object)"b", (Object)"<aqua>").put((Object)"c", (Object)"<red>").put((Object)"d", (Object)"<light_purple>").put((Object)"e", (Object)"<yellow>").put((Object)"f", (Object)"<white>").put((Object)"k", (Object)"<magic>").put((Object)"l", (Object)"<bold>").put((Object)"m", (Object)"<strikethrough>").put((Object)"n", (Object)"<underlined>").put((Object)"o", (Object)"<italic>").put((Object)"r", (Object)"<reset>").build();

    public Messages(File file, Logger logger, Map<String, Object> map, Map<String, String> map2) {
        this.logger = logger;
        this.pluginFolder = file;
        this.defaultValues = map;
        this.moving = map2;
        this.loadMessagesFile(map, map2);
    }

    public Messages(File file, Logger logger, Map<String, Object> map) {
        this.logger = logger;
        this.pluginFolder = file;
        this.defaultValues = map;
        this.moving = new HashMap<String, String>();
        this.loadMessagesFile(map, this.moving);
    }

    private void loadMessagesFile(Map<String, Object> map, Map<String, String> map2) {
        this.msgFile = new File(this.pluginFolder, "messages.yml");
        this.loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(this.msgFile)).nodeStyle(NodeStyle.BLOCK).build();
        try {
            this.msgs = (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException iOException) {
            this.logger.severe("Unable to load messages file:");
            iOException.printStackTrace();
            return;
        }
        for (String string : map2.keySet()) {
            ConfigurationNode configurationNode;
            Object[] objectArray = string.split("\\.");
            if (!this.msgs.hasChild(objectArray) || !(configurationNode = this.msgs.node(objectArray)).isList()) continue;
            try {
                ((CommentedConfigurationNode)this.msgs.node(new Object[]{map2.get(string)})).set(((CommentedConfigurationNode)this.msgs.node(objectArray)).getList(String.class));
            }
            catch (SerializationException serializationException) {
                this.logger.log(Level.SEVERE, "Unable to move message:", serializationException);
            }
        }
        for (String string : map.keySet()) {
            if (this.msgs.hasChild(string.split("\\."))) continue;
            try {
                ((CommentedConfigurationNode)((CommentedConfigurationNode)this.msgs.node(string.split("\\."))).node(new Object[0])).set(map.get(string));
            }
            catch (SerializationException serializationException) {
                this.logger.log(Level.SEVERE, "Unable to set message in file:", serializationException);
            }
        }
        try {
            this.loader.save(this.msgs);
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, "Unable to save messages file:", iOException);
        }
    }

    @Deprecated
    public String get(String string) {
        String string2 = ((CommentedConfigurationNode)this.msgs.node(string.split("\\."))).getString("&cMessage '" + string + "' does not exist!");
        string2 = Messages.color(string2);
        return string2;
    }

    public String getRawString(String string, String ... stringArray) {
        String string2 = ((CommentedConfigurationNode)this.msgs.node(string.split("\\."))).getString("&cMessage '" + string + "' does not exist!");
        for (String string3 : stringArray) {
            String string4 = string3.split(":")[0];
            String string5 = string3.replaceFirst(Matcher.quoteReplacement(string4 + ":"), "");
            string2 = string2.replaceAll("\\{" + Matcher.quoteReplacement(string4) + "}", string5);
        }
        return string2;
    }

    public String getString(String string, String ... stringArray) {
        String string2 = ((CommentedConfigurationNode)this.msgs.node(string.split("\\."))).getString("&cMessage '" + string + "' does not exist!");
        for (String string3 : stringArray) {
            String string4 = string3.split(":")[0];
            String string5 = string3.replaceFirst(Matcher.quoteReplacement(string4 + ":"), "");
            string2 = string2.replaceAll("\\{" + Matcher.quoteReplacement(string4) + "}", string5);
        }
        string2 = Messages.color(string2);
        return string2;
    }

    public List<String> getStringList(String string, String ... stringArray) {
        List<Object> list;
        try {
            if (this.hasMessage(string)) {
                list = ((CommentedConfigurationNode)this.msgs.node(string.split("\\."))).getList(String.class);
                if (list != null) {
                    list = new ArrayList(list);
                }
            } else {
                list = new ArrayList<String>();
                list.add("&cMessage '" + string + "' does not exist!");
            }
        }
        catch (SerializationException serializationException) {
            this.logger.log(Level.WARNING, "List '" + string + "' must be all strings!", serializationException);
            return new ArrayList<String>();
        }
        for (int i = 0; i < list.size(); ++i) {
            String string2 = Messages.color((String)list.get(i));
            for (String string3 : stringArray) {
                String string4 = string3.split(":")[0];
                String string5 = string3.replaceFirst(Matcher.quoteReplacement(string4 + ":"), "");
                string2 = string2.replaceAll("\\{" + Matcher.quoteReplacement(string4) + "}", string5);
            }
            list.set(i, string2);
        }
        return list;
    }

    public List<String> getMMStringList(String string, String ... stringArray) {
        List<String> list = this.getStringList(string, stringArray);
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            Object o = this.getMiniMessage().deserialize(string2);
            string2 = this.legacyComponentSerializer.serialize((Component)o);
            list.set(i, string2);
        }
        return list;
    }

    public String getMMString(String string, String ... stringArray) {
        return this.getMMString(string, false, stringArray);
    }

    public String getMMString(String string, boolean bl, String ... stringArray) {
        String string2 = this.getString(string, stringArray);
        if (bl) {
            string2 = string2 + "a";
        }
        Object o = this.getMiniMessage().deserialize(string2);
        string2 = this.legacyComponentSerializer.serialize((Component)o);
        if (bl) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public List<Component> getComponentList(String string, String ... stringArray) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        List<String> list = this.getStringList(string, stringArray);
        for (String string2 : list) {
            arrayList.add(this.toComponent(string2));
        }
        return arrayList;
    }

    public boolean hasMessage(String string) {
        ConfigurationNode configurationNode = this.msgs.node(string.split("\\."));
        return !configurationNode.virtual() && !configurationNode.isNull();
    }

    public Component getRandomFromList(String string, String ... stringArray) {
        List<String> list = this.getStringList(string, stringArray);
        String string2 = list.get(this.random.nextInt(list.size() - 1));
        return this.toComponent(string2);
    }

    public boolean isEmpty(String string) {
        return this.getString(string, new String[0]).length() == 0;
    }

    public BaseComponent[] getBC(String string, String ... stringArray) {
        return this.getBC(this.getComponent(string, stringArray));
    }

    public BaseComponent[] getBC(Component component) {
        return BungeeComponentSerializer.get().serialize(component);
    }

    public Component getComponent(String string, String ... stringArray) {
        String string2 = this.getString(string, stringArray);
        return this.getMiniMessage().deserialize(string2);
    }

    public MiniMessage getMiniMessage() {
        if (this.miniMessage == null) {
            this.miniMessage = MiniMessage.miniMessage();
        }
        return this.miniMessage;
    }

    public Component toComponent(String string) {
        return this.getMiniMessage().deserialize(Messages.color(string));
    }

    public static String color(String string) {
        for (Map.Entry entry : colorReplacements.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            string = string.replaceAll(Matcher.quoteReplacement("&" + string2), Matcher.quoteReplacement(string3));
            string = string.replaceAll(Matcher.quoteReplacement('\u00b7' + string2), Matcher.quoteReplacement(string3));
        }
        return string;
    }

    public void reload() {
        this.loadMessagesFile(this.defaultValues, this.moving);
    }

    public CommentedConfigurationNode getRootNode() {
        return this.msgs;
    }

    public void save() {
        try {
            this.loader.save(this.msgs);
        }
        catch (IOException iOException) {
            this.logger.log(Level.SEVERE, "Unable to save messages file:", iOException);
        }
    }

    public static Map<String, Object> makeDefaults(Object ... objectArray) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!(objectArray[i] instanceof String)) {
                throw new IllegalArgumentException("Key must be string! It was " + objectArray[i].toString());
            }
            if (i + 1 >= objectArray.length) {
                throw new IllegalArgumentException("Odd arguments supplied! (must have a key and a value)");
            }
            linkedHashMap.put((String)objectArray[i], objectArray[i + 1]);
        }
        return linkedHashMap;
    }
}

