/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.utils.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.ajg0702.queue.libs.sponge.configurate.CommentedConfigurationNode;
import us.ajg0702.queue.libs.sponge.configurate.loader.HeaderMode;
import us.ajg0702.queue.libs.sponge.configurate.serialize.SerializationException;
import us.ajg0702.queue.libs.sponge.configurate.yaml.NodeStyle;
import us.ajg0702.queue.libs.sponge.configurate.yaml.YamlConfigurationLoader;
import us.ajg0702.queue.libs.utils.common.WritableConfigInterface;

public class SimpleConfig
implements WritableConfigInterface {
    private final YamlConfigurationLoader loader;
    private CommentedConfigurationNode parentNode;
    private final Logger logger;

    public SimpleConfig(File file, String string, Logger logger) {
        this(file, string, logger, null);
    }

    public SimpleConfig(File file, String string, Logger logger, String string2) {
        this.logger = logger;
        File file2 = new File(file, string);
        YamlConfigurationLoader.Builder builder = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().headerMode(HeaderMode.PRESET)).file(file2)).nodeStyle(NodeStyle.BLOCK);
        if (string2 != null) {
            builder.defaultOptions(builder.defaultOptions().header(string2));
        }
        this.loader = builder.build();
        if (!file2.exists()) {
            if (!Files.exists(file.toPath(), new LinkOption[0])) {
                try {
                    Files.createDirectory(file.toPath(), new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "Unable to folder for " + string + ":", iOException);
                }
            }
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
                if (inputStream != null) {
                    Files.copy(inputStream, file2.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Unable to create default file for " + string + ":", iOException);
            }
        }
        this.parentNode = (CommentedConfigurationNode)this.loader.load();
    }

    public CommentedConfigurationNode getNode(String string) {
        return (CommentedConfigurationNode)this.parentNode.node(this.path(string));
    }

    public CommentedConfigurationNode getNode() {
        return this.parentNode;
    }

    private Object[] path(String string) {
        return string.split("\\.");
    }

    @Override
    public Object get(String string) {
        try {
            return ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).get(Object.class);
        }
        catch (SerializationException serializationException) {
            return null;
        }
    }

    @Override
    public Integer getInt(String string) {
        return ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).getInt(-1);
    }

    @Override
    public String getString(String string) {
        return ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).getString();
    }

    @Override
    public List<String> getStringList(String string) {
        try {
            return ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).getList(String.class);
        }
        catch (SerializationException serializationException) {
            throw new IllegalArgumentException(string + " is not a list! " + serializationException.getMessage());
        }
    }

    @Override
    public boolean getBoolean(String string) {
        return ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).getBoolean();
    }

    @Override
    public double getDouble(String string) {
        return ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).getDouble();
    }

    @Override
    public void reload() {
        this.parentNode = (CommentedConfigurationNode)this.loader.load();
    }

    @Override
    public void set(String string, Object object) {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).set(object);
    }

    @Override
    public void setInt(String string, int n) {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).set(n);
    }

    @Override
    public void setString(String string, String string2) {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).set(string2);
    }

    @Override
    public void setStringList(String string, List<String> list) {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).set(list);
    }

    @Override
    public void setBoolean(String string, boolean bl) {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).set(bl);
    }

    @Override
    public void setDouble(String string, double d) {
        ((CommentedConfigurationNode)this.parentNode.node(this.path(string))).set(d);
    }

    @Override
    public void save() {
        this.loader.save(this.parentNode);
    }
}

