/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.logic.permissions.hooks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.TechsCode.UltraPermissions.UltraPermissions;
import me.TechsCode.UltraPermissions.UltraPermissionsAPI;
import me.TechsCode.UltraPermissions.storage.objects.User;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.premium.PermissionHook;
import us.ajg0702.queue.common.QueueMain;

public class UltraPermissionsHook
implements PermissionHook {
    private final QueueMain main;

    public UltraPermissionsHook(QueueMain queueMain) {
        this.main = queueMain;
    }

    @Override
    public String getName() {
        return "UltraPermissions";
    }

    @Override
    public boolean canUse() {
        if (!this.main.getPlatformMethods().hasPlugin("UltraPermissions")) {
            return false;
        }
        if (UltraPermissions.getAPI() == null) {
            this.main.getLogger().warn("UltraPermissions is installed, but its getApi() method returned null! Unable to hook into it.");
            return false;
        }
        return true;
    }

    @Override
    public List<String> getPermissions(AdaptedPlayer adaptedPlayer) {
        UltraPermissionsAPI ultraPermissionsAPI = UltraPermissions.getAPI();
        Optional optional = ultraPermissionsAPI.getUsers().uuid(adaptedPlayer.getUniqueId());
        if (!optional.isPresent()) {
            return new ArrayList<String>();
        }
        User user = (User)optional.get();
        ArrayList<String> arrayList = new ArrayList<String>();
        user.getPermissions().bungee().forEach(permission -> arrayList.add(permission.getName()));
        return arrayList;
    }
}

