/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.slf4j.Logger;
import us.ajg0702.queue.api.Implementation;
import us.ajg0702.queue.api.commands.IBaseCommand;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.commands.commands.leavequeue.LeaveCommand;
import us.ajg0702.queue.commands.commands.listqueues.ListCommand;
import us.ajg0702.queue.commands.commands.manage.ManageCommand;
import us.ajg0702.queue.commands.commands.queue.QueueCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.bstats.charts.SimplePie;
import us.ajg0702.queue.libs.bstats.velocity.Metrics;
import us.ajg0702.queue.platforms.velocity.VelocityLogger;
import us.ajg0702.queue.platforms.velocity.VelocityMethods;
import us.ajg0702.queue.platforms.velocity.commands.VelocityCommand;
import us.ajg0702.queue.platforms.velocity.players.VelocityPlayer;
import us.ajg0702.queue.platforms.velocity.server.VelocityServer;

@Plugin(id="ajqueue", name="ajQueue", version="2.5.0", url="https://ajg0702.us", description="Queue for servers", authors={"ajgeiss0702"})
public class VelocityQueue
implements Implementation {
    final ProxyServer proxyServer;
    final VelocityLogger logger;
    QueueMain main;
    final File dataFolder;
    private final Metrics.Factory metricsFactory;
    List<IBaseCommand> commands;
    CommandManager commandManager;

    @Inject
    public VelocityQueue(ProxyServer proxyServer, Logger logger, @DataDirectory Path path, Metrics.Factory factory) {
        this.proxyServer = proxyServer;
        this.logger = new VelocityLogger(logger);
        this.dataFolder = path.toFile();
        this.metricsFactory = factory;
    }

    @Subscribe
    public void onProxyInit(ProxyInitializeEvent proxyInitializeEvent) {
        this.commandManager = this.proxyServer.getCommandManager();
        this.main = new QueueMain(this, this.logger, new VelocityMethods(this, this.proxyServer, this.logger), this.dataFolder);
        this.commands = Arrays.asList(new QueueCommand(this.main), new LeaveCommand(this.main), new ListCommand(this.main), new ManageCommand(this.main));
        this.proxyServer.getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.create((String)"ajqueue", (String)"tospigot")});
        this.proxyServer.getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)"ajqueue:toproxy")});
        for (IBaseCommand iBaseCommand : this.commands) {
            this.registerCommand(iBaseCommand);
        }
        Metrics metrics = this.metricsFactory.make(this, 7404);
        metrics.addCustomChart(new SimplePie("premium", () -> String.valueOf(this.main.getLogic().isPremium())));
        metrics.addCustomChart(new SimplePie("implementation", () -> this.main.getPlatformMethods().getImplementationName()));
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent proxyShutdownEvent) {
        this.main.shutdown();
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent pluginMessageEvent) {
        if (pluginMessageEvent.getIdentifier().getId().equals("ajqueue:tospigot")) {
            pluginMessageEvent.setResult(PluginMessageEvent.ForwardResult.handled());
            return;
        }
        if (!pluginMessageEvent.getIdentifier().getId().equals("ajqueue:toproxy")) {
            return;
        }
        pluginMessageEvent.setResult(PluginMessageEvent.ForwardResult.handled());
        if (!(pluginMessageEvent.getTarget() instanceof Player)) {
            return;
        }
        this.main.getEventHandler().handleMessage(new VelocityPlayer((Player)pluginMessageEvent.getTarget()), pluginMessageEvent.getData());
    }

    @Subscribe
    public void onJoin(ServerPostConnectEvent serverPostConnectEvent) {
        if (serverPostConnectEvent.getPreviousServer() == null) {
            this.main.getEventHandler().onPlayerJoin(new VelocityPlayer(serverPostConnectEvent.getPlayer()));
        }
        this.main.getEventHandler().onPlayerJoinServer(new VelocityPlayer(serverPostConnectEvent.getPlayer()));
    }

    @Subscribe
    public void onLeave(DisconnectEvent disconnectEvent) {
        this.main.getEventHandler().onPlayerLeave(new VelocityPlayer(disconnectEvent.getPlayer()));
    }

    @Subscribe
    public void onKick(KickedFromServerEvent kickedFromServerEvent) {
        if (!kickedFromServerEvent.getPlayer().getCurrentServer().isPresent()) {
            return;
        }
        Optional optional = kickedFromServerEvent.getServerKickReason();
        this.main.getEventHandler().onServerKick(new VelocityPlayer(kickedFromServerEvent.getPlayer()), new VelocityServer(kickedFromServerEvent.getServer()), optional.orElseGet(() -> Component.text("Proxy lost connection")), kickedFromServerEvent.kickedDuringServerConnect());
    }

    @Override
    public void unregisterCommand(String string) {
        this.commandManager.unregister(string);
    }

    @Override
    public void registerCommand(IBaseCommand iBaseCommand) {
        this.commandManager.register(this.commandManager.metaBuilder(iBaseCommand.getName()).aliases((String[])iBaseCommand.getAliases().toArray((Object[])new String[0])).build(), (Command)new VelocityCommand(this.main, (BaseCommand)iBaseCommand));
    }

    public QueueMain getMain() {
        return this.main;
    }
}

