/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.velocity.players;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.viaversion.viaversion.api.Via;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.platforms.velocity.server.VelocityServer;

public class VelocityPlayer
implements AdaptedPlayer,
Audience {
    final Player handle;
    private final boolean viaAvailable;

    @Override
    public void showTitle(@NotNull Title title) {
        this.handle.showTitle(title);
    }

    @Override
    public void clearTitle() {
        this.handle.clearTitle();
    }

    @Override
    public void resetTitle() {
        this.handle.resetTitle();
    }

    @Override
    public void showBossBar(@NotNull BossBar bossBar) {
        this.handle.showBossBar(bossBar);
    }

    @Override
    public void hideBossBar(@NotNull BossBar bossBar) {
        this.handle.hideBossBar(bossBar);
    }

    @Override
    public void playSound(@NotNull Sound sound) {
        this.handle.playSound(sound);
    }

    @Override
    public void playSound(@NotNull Sound sound, double d, double d2, double d3) {
        this.handle.playSound(sound, d, d2, d3);
    }

    @Override
    public void stopSound(@NotNull Sound sound) {
        this.handle.stopSound(sound);
    }

    @Override
    public void playSound(@NotNull Sound sound, @NotNull Sound.Emitter emitter) {
        this.handle.playSound(sound, emitter);
    }

    @Override
    public void stopSound(@NotNull SoundStop soundStop) {
        this.handle.stopSound(soundStop);
    }

    public VelocityPlayer(Player player) {
        this.handle = player;
        this.viaAvailable = VelocityPlayer.isClassAvailable("com.viaversion.viaversion.api.Via");
    }

    @Override
    public boolean isConnected() {
        return this.handle.isActive();
    }

    @Override
    public void sendMessage(@NotNull Component component) {
        if (PlainTextComponentSerializer.plainText().serialize(component).isEmpty()) {
            return;
        }
        this.handle.sendMessage(component);
    }

    @Override
    public void sendActionBar(@NotNull Component component) {
        this.handle.sendActionBar(component);
    }

    @Override
    public void sendMessage(String string) {
        this.sendMessage(Component.text(string));
    }

    @Override
    public boolean hasPermission(String string) {
        return this.handle.hasPermission(string);
    }

    @Override
    public String getServerName() {
        AdaptedServer adaptedServer = this.getCurrentServer();
        if (adaptedServer == null) {
            return null;
        }
        return adaptedServer.getName();
    }

    @Override
    public AdaptedServer getCurrentServer() {
        Optional optional = this.handle.getCurrentServer();
        if (!optional.isPresent()) {
            return null;
        }
        ServerConnection serverConnection = (ServerConnection)optional.get();
        return new VelocityServer(serverConnection.getServer());
    }

    @Override
    public UUID getUniqueId() {
        return this.handle.getUniqueId();
    }

    @Override
    public void connect(AdaptedServer adaptedServer) {
        Debug.info("Attempting to send " + this.getName() + " to " + adaptedServer.getName());
        this.handle.createConnectionRequest((RegisteredServer)adaptedServer.getHandle()).connect().thenAcceptAsync(result -> {
            if (!result.isSuccessful()) {
                QueueMain queueMain = QueueMain.getInstance();
                Component component = result.getReasonComponent().orElse(null);
                if (component == null) {
                    switch (result.getStatus()) {
                        case SUCCESS: {
                            component = Component.text("Success");
                            break;
                        }
                        case ALREADY_CONNECTED: {
                            component = Component.text("Already connected");
                            break;
                        }
                        case CONNECTION_IN_PROGRESS: {
                            component = Component.text("Already connecting");
                            break;
                        }
                        case CONNECTION_CANCELLED: {
                            component = Component.text("Connection canceled");
                            break;
                        }
                        case SERVER_DISCONNECTED: {
                            component = Component.text("Connection failed with unknown reason");
                        }
                    }
                }
                if (queueMain.getConfig().getBoolean("velocity-kick-message")) {
                    this.handle.sendMessage(queueMain.getMessages().getComponent("velocity-kick-message", "SERVER:" + adaptedServer.getName(), "REASON:" + LegacyComponentSerializer.legacyAmpersand().serialize(component)));
                }
                queueMain.getEventHandler().onServerKick(this, adaptedServer, component, false);
            }
        });
    }

    @Override
    public int getProtocolVersion() {
        if (this.viaAvailable) {
            return Via.getAPI().getPlayerVersion(this.handle.getUniqueId());
        }
        return this.handle.getProtocolVersion().getProtocol();
    }

    @Override
    public String getName() {
        return this.handle.getUsername();
    }

    @Override
    public void kick(Component component) {
        this.handle.disconnect(component);
    }

    @Override
    public List<String> getPermissions() {
        throw new IllegalStateException("AdaptedPlayer#getPermissions cannot be used on velocity");
    }

    public Player getHandle() {
        return this.handle;
    }

    private static boolean isClassAvailable(String string) {
        try {
            Class.forName(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        VelocityPlayer velocityPlayer = (VelocityPlayer)object;
        return this.handle.equals(velocityPlayer.handle);
    }

    public int hashCode() {
        return Objects.hash(this.handle);
    }
}

