/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.velocity.server;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import us.ajg0702.queue.api.AjQueueAPI;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.api.server.AdaptedServerInfo;
import us.ajg0702.queue.api.server.AdaptedServerPing;
import us.ajg0702.queue.api.util.QueueLogger;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.platforms.velocity.players.VelocityPlayer;
import us.ajg0702.queue.platforms.velocity.server.VelocityServerInfo;
import us.ajg0702.queue.platforms.velocity.server.VelocityServerPing;

public class VelocityServer
implements AdaptedServer {
    private final RegisteredServer handle;
    private AdaptedServerPing lastPing = null;
    private AdaptedServerPing lastSuccessfullPing = null;
    private long lastOffline = 0L;
    private int offlineTime = 0;

    public VelocityServer(RegisteredServer registeredServer) {
        this.handle = registeredServer;
    }

    @Override
    public AdaptedServerInfo getServerInfo() {
        return new VelocityServerInfo(this.handle.getServerInfo());
    }

    @Override
    public String getName() {
        return this.handle.getServerInfo().getName();
    }

    @Override
    public CompletableFuture<AdaptedServerPing> ping(boolean bl, QueueLogger queueLogger) {
        CompletableFuture<AdaptedServerPing> completableFuture = new CompletableFuture<AdaptedServerPing>();
        long l = System.currentTimeMillis();
        CompletableFuture completableFuture2 = this.handle.ping();
        if (bl) {
            queueLogger.info("[pinger] [" + this.getName() + "] sending ping");
        }
        ((CompletableFuture)completableFuture2.thenRunAsync(() -> {
            VelocityServerPing velocityServerPing;
            try {
                velocityServerPing = new VelocityServerPing((ServerPing)completableFuture2.get(), l);
            }
            catch (Throwable throwable) {
                this.markOffline(bl, queueLogger, completableFuture, l, throwable);
                return;
            }
            this.offlineTime = 0;
            this.lastSuccessfullPing = velocityServerPing;
            if (bl) {
                queueLogger.info("[pinger] [" + this.getName() + "] online. motd: " + velocityServerPing.getPlainDescription() + "  players: " + velocityServerPing.getPlayerCount() + "/" + velocityServerPing.getMaxPlayers());
            }
            completableFuture.complete(velocityServerPing);
            this.lastPing = velocityServerPing;
        })).exceptionally(throwable -> {
            this.markOffline(bl, queueLogger, completableFuture, l, (Throwable)throwable);
            return null;
        });
        return completableFuture;
    }

    private void markOffline(boolean bl, QueueLogger queueLogger, CompletableFuture<AdaptedServerPing> completableFuture, long l, Throwable throwable) {
        long l2 = this.lastSuccessfullPing == null ? 0L : this.lastSuccessfullPing.getFetchedTime();
        this.offlineTime = (int)Math.min(l - l2, Integer.MAX_VALUE) / 1000;
        this.lastOffline = l;
        completableFuture.completeExceptionally(throwable);
        this.lastPing = null;
        if (bl) {
            queueLogger.info("[pinger] [" + this.getName() + "] offline:", throwable);
        }
    }

    @Override
    public Optional<AdaptedServerPing> getLastPing() {
        return Optional.ofNullable(this.lastPing);
    }

    @Override
    public boolean canAccess(AdaptedPlayer adaptedPlayer) {
        return true;
    }

    @Override
    public List<AdaptedPlayer> getPlayers() {
        ArrayList<AdaptedPlayer> arrayList = new ArrayList<AdaptedPlayer>();
        for (Player player : this.handle.getPlayersConnected()) {
            arrayList.add(new VelocityPlayer(player));
        }
        return arrayList;
    }

    @Override
    public int getOfflineTime() {
        return this.offlineTime;
    }

    @Override
    public boolean canJoinFull(AdaptedPlayer adaptedPlayer) {
        if (adaptedPlayer == null) {
            return true;
        }
        Debug.info("on " + this.getName());
        return adaptedPlayer.hasPermission("ajqueue.joinfull") || adaptedPlayer.hasPermission("ajqueue.joinfullserver." + this.getName()) || adaptedPlayer.hasPermission("ajqueue.joinfullandbypassserver." + this.getName()) || adaptedPlayer.hasPermission("ajqueue.joinfullandbypass") || AjQueueAPI.getInstance().isPremium() && AjQueueAPI.getInstance().getLogic().getPermissionGetter().hasUniqueFullBypass(adaptedPlayer, this.getName());
    }

    @Override
    public boolean justWentOnline() {
        return (double)(System.currentTimeMillis() - this.lastOffline) <= AjQueueAPI.getInstance().getConfig().getDouble("wait-time") * 2.0 * 1000.0 && this.isOnline();
    }

    public RegisteredServer getHandle() {
        return this.handle;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VelocityServer)) {
            return false;
        }
        VelocityServer velocityServer = (VelocityServer)object;
        return this.getHandle().equals(velocityServer.getHandle());
    }

    public int hashCode() {
        return Objects.hash(this.getHandle());
    }
}

