/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.api;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import us.ajg0702.queue.api.spigot.AjQueueSpigotAPI;
import us.ajg0702.queue.api.spigot.MessagedResponse;
import us.ajg0702.queue.spigot.SpigotMain;
import us.ajg0702.queue.spigot.communication.ResponseManager;

public class SpigotAPI
extends AjQueueSpigotAPI {
    private final ResponseManager responseManager;
    private final SpigotMain main;

    public SpigotAPI(ResponseManager responseManager, SpigotMain spigotMain) {
        this.responseManager = responseManager;
        this.main = spigotMain;
    }

    @Override
    public Future<Boolean> isInQueue(UUID uUID) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            throw new IllegalArgumentException("Player must be online!");
        }
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.responseManager.awaitResponse(uUID.toString(), "inqueue", comResponse -> completableFuture.complete(Boolean.valueOf(comResponse.getResponse())));
        this.main.sendMessage(player, "inqueue", "");
        return completableFuture;
    }

    @Override
    public Future<Boolean> addToQueue(UUID uUID, String string) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            throw new IllegalArgumentException("Player must be online!");
        }
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.responseManager.awaitResponse(uUID.toString(), "serverqueue", comResponse -> completableFuture.complete(Boolean.valueOf(comResponse.getResponse())));
        this.main.sendMessage(player, "serverqueue", string);
        return completableFuture;
    }

    @Override
    public void sudoQueue(UUID uUID, String string) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            throw new IllegalArgumentException("Player must be online!");
        }
        this.main.sendMessage(player, "queue", string);
    }

    @Override
    public Future<MessagedResponse<String>> getQueueName(UUID uUID) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            throw new IllegalArgumentException("Player must be online!");
        }
        CompletableFuture<MessagedResponse<String>> completableFuture = new CompletableFuture<MessagedResponse<String>>();
        this.responseManager.awaitResponse(uUID.toString(), "queuename", comResponse -> completableFuture.complete(new MessagedResponse<String>(comResponse.getResponse(), comResponse.getNoneMessage())));
        this.main.sendMessage(player, "queuename", "");
        return completableFuture;
    }

    @Override
    public Future<MessagedResponse<Integer>> getPosition(UUID uUID) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            throw new IllegalArgumentException("Player must be online!");
        }
        CompletableFuture<MessagedResponse<Integer>> completableFuture = new CompletableFuture<MessagedResponse<Integer>>();
        this.responseManager.awaitResponse(uUID.toString(), "position", comResponse -> {
            String string = comResponse.getResponse();
            Integer n = string == null ? null : Integer.valueOf(string);
            completableFuture.complete(new MessagedResponse<Integer>(n, comResponse.getNoneMessage()));
        });
        this.main.sendMessage(player, "position", "");
        return completableFuture;
    }

    @Override
    public Future<MessagedResponse<Integer>> getTotalPositions(UUID uUID) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            throw new IllegalArgumentException("Player must be online!");
        }
        CompletableFuture<MessagedResponse<Integer>> completableFuture = new CompletableFuture<MessagedResponse<Integer>>();
        this.responseManager.awaitResponse(uUID.toString(), "positionof", comResponse -> {
            String string = comResponse.getResponse();
            Integer n = string == null ? null : Integer.valueOf(string);
            completableFuture.complete(new MessagedResponse<Integer>(n, comResponse.getNoneMessage()));
        });
        this.main.sendMessage(player, "positionof", "");
        return completableFuture;
    }

    @Override
    public Future<Integer> getPlayersInQueue(String string) {
        Player player = (Player)Bukkit.getOnlinePlayers().iterator().next();
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        this.responseManager.awaitResponse(string, "queuedfor", comResponse -> {
            String string2 = comResponse.getResponse();
            if (string2.equals("invalid_server")) {
                completableFuture.completeExceptionally(new IllegalArgumentException(string + " does not exist!"));
            }
            completableFuture.complete(Integer.valueOf(string2));
        });
        this.main.sendMessage(player, "queuedfor", string);
        return completableFuture;
    }

    @Override
    public Future<String> getServerStatusString(String string) {
        return this.getServerStatusString(string, null);
    }

    @Override
    public Future<String> getServerStatusString(String string, UUID uUID) {
        Player player;
        Player player2 = player = uUID == null ? (Player)Bukkit.getOnlinePlayers().iterator().next() : Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            throw new IllegalArgumentException("Player must be online!");
        }
        String string2 = uUID == null ? "status" : "playerstatus";
        CompletableFuture<String> completableFuture = new CompletableFuture<String>();
        this.responseManager.awaitResponse(string, string2, comResponse -> {
            String string2 = comResponse.getResponse();
            if (string2.equals("invalid_server")) {
                completableFuture.completeExceptionally(new IllegalArgumentException(string + " does not exist!"));
            }
            completableFuture.complete(string2);
        });
        this.main.sendMessage(player, string2, string);
        return completableFuture;
    }

    @Override
    public Future<MessagedResponse<String>> getEstimatedTime(UUID uUID) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player == null) {
            throw new IllegalArgumentException("Player must be online!");
        }
        CompletableFuture<MessagedResponse<String>> completableFuture = new CompletableFuture<MessagedResponse<String>>();
        this.responseManager.awaitResponse(uUID.toString(), "estimated_time", comResponse -> completableFuture.complete(new MessagedResponse<String>(comResponse.getResponse(), comResponse.getNoneMessage())));
        this.main.sendMessage(player, "estimated_time", "");
        return completableFuture;
    }
}

