/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot.placeholders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.spigot.SpigotMain;
import us.ajg0702.queue.spigot.placeholders.CachedPlaceholder;
import us.ajg0702.queue.spigot.placeholders.Placeholder;
import us.ajg0702.queue.spigot.placeholders.placeholders.EstimatedTime;
import us.ajg0702.queue.spigot.placeholders.placeholders.InQueue;
import us.ajg0702.queue.spigot.placeholders.placeholders.Position;
import us.ajg0702.queue.spigot.placeholders.placeholders.PositionOf;
import us.ajg0702.queue.spigot.placeholders.placeholders.Queued;
import us.ajg0702.queue.spigot.placeholders.placeholders.QueuedFor;
import us.ajg0702.queue.spigot.placeholders.placeholders.Status;
import us.ajg0702.queue.spigot.placeholders.placeholders.StatusPlayer;

public class PlaceholderExpansion
extends me.clip.placeholderapi.expansion.PlaceholderExpansion {
    private final List<Placeholder> placeholders = new ArrayList<Placeholder>();
    private final SpigotMain plugin;
    Map<String, CachedPlaceholder> placeholderCache = new HashMap<String, CachedPlaceholder>();

    public PlaceholderExpansion(SpigotMain spigotMain) {
        this.plugin = spigotMain;
        this.placeholders.add(new EstimatedTime(spigotMain));
        this.placeholders.add(new InQueue(spigotMain));
        this.placeholders.add(new Position(spigotMain));
        this.placeholders.add(new PositionOf(spigotMain));
        this.placeholders.add(new Queued(spigotMain));
        this.placeholders.add(new QueuedFor(spigotMain));
        this.placeholders.add(new Status(spigotMain));
        this.placeholders.add(new StatusPlayer(spigotMain));
    }

    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String string) {
        if (offlinePlayer == null || !offlinePlayer.isOnline()) {
            return "No player";
        }
        CachedPlaceholder cachedPlaceholder = this.placeholderCache.computeIfAbsent(string, string2 -> {
            for (Placeholder placeholder : this.placeholders) {
                Matcher matcher = placeholder.getPattern().matcher(string);
                if (!matcher.matches()) continue;
                return new CachedPlaceholder(matcher, placeholder);
            }
            return null;
        });
        if (cachedPlaceholder == null) {
            return null;
        }
        return cachedPlaceholder.getPlaceholder().parse(cachedPlaceholder.getMatcher(), offlinePlayer);
    }

    @NotNull
    public String getIdentifier() {
        return "ajqueue";
    }

    @NotNull
    public String getAuthor() {
        return "ajgeiss0702";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public void cleanCache(Player player) {
        this.placeholders.forEach(placeholder -> placeholder.cleanCache(player));
    }
}

