/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import me.mrgeneralq.bloodmoon.bstats.Metrics;
import me.mrgeneralq.bloodmoon.commands.BloodmoonCommand;
import me.mrgeneralq.bloodmoon.commands.OnTabComplete;
import me.mrgeneralq.bloodmoon.defaults.DefaultAction;
import me.mrgeneralq.bloodmoon.defaults.DefaultLifecycle;
import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.eventlisteners.OnBlockBreak;
import me.mrgeneralq.bloodmoon.eventlisteners.OnBloodmoonSchedule;
import me.mrgeneralq.bloodmoon.eventlisteners.OnBloodmoonStart;
import me.mrgeneralq.bloodmoon.eventlisteners.OnBloodmoonStop;
import me.mrgeneralq.bloodmoon.eventlisteners.OnEntityDamage;
import me.mrgeneralq.bloodmoon.eventlisteners.OnEntityDeath;
import me.mrgeneralq.bloodmoon.eventlisteners.OnHarvest;
import me.mrgeneralq.bloodmoon.eventlisteners.OnLightningStrike;
import me.mrgeneralq.bloodmoon.eventlisteners.OnMobSpawn;
import me.mrgeneralq.bloodmoon.eventlisteners.OnPlayerBedEnter;
import me.mrgeneralq.bloodmoon.eventlisteners.OnPlayerCommandPreProcess;
import me.mrgeneralq.bloodmoon.eventlisteners.OnPlayerDeath;
import me.mrgeneralq.bloodmoon.eventlisteners.OnPlayerItemUse;
import me.mrgeneralq.bloodmoon.eventlisteners.OnPlayerJoin;
import me.mrgeneralq.bloodmoon.eventlisteners.OnPlayerPortal;
import me.mrgeneralq.bloodmoon.eventlisteners.OnSignBreak;
import me.mrgeneralq.bloodmoon.eventlisteners.OnSignCreate;
import me.mrgeneralq.bloodmoon.eventlisteners.OnSignInteract;
import me.mrgeneralq.bloodmoon.eventlisteners.OnWorldChange;
import me.mrgeneralq.bloodmoon.factories.PlayerDeathActionFactory;
import me.mrgeneralq.bloodmoon.factories.SignActionFactory;
import me.mrgeneralq.bloodmoon.hooks.wildstacker.WildstackerEventListener;
import me.mrgeneralq.bloodmoon.interfaces.services.IActionService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.ILifeCycleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.interfaces.services.IResourcePackService;
import me.mrgeneralq.bloodmoon.interfaces.services.ISoundService;
import me.mrgeneralq.bloodmoon.interfaces.services.IUpdateService;
import me.mrgeneralq.bloodmoon.runnables.HeartBeat;
import me.mrgeneralq.bloodmoon.runnables.NightTimer;
import me.mrgeneralq.bloodmoon.runnables.SoundTimer;
import me.mrgeneralq.bloodmoon.statics.Bootstrapper;
import me.mrgeneralq.bloodmoon.statics.ConfigManager;
import me.mrgeneralq.bloodmoon.statics.Message;
import me.mrgeneralq.bloodmoon.statics.PapiExtension;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class BloodmoonCore
extends JavaPlugin {
    private IBloodmoonService bloodmoonService;
    private IConfigService configService;
    private IMessageService messageService;

    public void onEnable() {
        World world2;
        BloodmoonCore.loadConfig0();
        String string = "1717051";
        String string2 = "-1930338753";
        String string3 = String.format("[bloodmoon-advanced] plugin registered for user %s with nonce %s", string, string2);
        Bukkit.getLogger().info(string3);
        try {
            int n = 6360;
            new Metrics((Plugin)this, 6360);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        ConfigurationSerialization.registerClass(DefaultMob.class);
        ConfigurationSerialization.registerClass(DefaultAction.class);
        ConfigurationSerialization.registerClass(DefaultLifecycle.class);
        this.saveDefaultConfig();
        ConfigManager.initialize(this);
        ConfigManager configManager = ConfigManager.getManager();
        configManager.createConfig("mobs");
        configManager.createConfig("messages");
        configManager.createConfig("schedules");
        Bootstrapper bootstrapper = Bootstrapper.getBootstrapper();
        bootstrapper.runBootstrapper(this);
        IMessageService iMessageService = bootstrapper.getMessageService();
        this.configService = bootstrapper.getConfigService();
        this.bloodmoonService = bootstrapper.getBloodmoonService();
        this.messageService = bootstrapper.getMessageService();
        IMobService iMobService = bootstrapper.getMobService();
        IItemService iItemService = bootstrapper.getItemService();
        ILifeCycleService iLifeCycleService = bootstrapper.getLifeCycleService();
        IActionService iActionService = bootstrapper.getActionService();
        ISoundService iSoundService = bootstrapper.getSoundService();
        IUpdateService iUpdateService = bootstrapper.getUpdateService();
        IResourcePackService iResourcePackService = bootstrapper.getResourcePackService();
        IBloodmoonScheduleService iBloodmoonScheduleService = bootstrapper.getBloodmoonScheduleService();
        if (!this.configService.getCurrentVersion().equalsIgnoreCase(this.configService.getConfigVersion())) {
            Bukkit.getLogger().warning(Message.getMessage("[bloodmoon-advanced] Config is not up-to-date! Please update the config!"));
        }
        this.bloodmoonService.loadMemory();
        for (World world2 : Bukkit.getWorlds()) {
            this.bloodmoonService.registerPlayersForBossBar(world2);
        }
        iBloodmoonScheduleService.loadMemory();
        Bukkit.getPluginManager().registerEvents((Listener)new OnBloodmoonStart(this.bloodmoonService, this.configService, iMessageService, iSoundService, this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnBloodmoonStop(this.bloodmoonService, this.configService, iMessageService, iSoundService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnBloodmoonSchedule(this.bloodmoonService, this.configService, iMessageService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnPlayerPortal(this.bloodmoonService, this.configService, iMessageService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnMobSpawn(this.bloodmoonService, this.configService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnEntityDeath(this.bloodmoonService, iMobService, this.configService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnEntityDamage(this.bloodmoonService, iMobService, this.configService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnLightningStrike(this.bloodmoonService, this.configService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnPlayerBedEnter(this.bloodmoonService, this.configService, iMessageService, iBloodmoonScheduleService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnPlayerJoin(this.bloodmoonService, this.configService, iMessageService, iUpdateService, iResourcePackService, iBloodmoonScheduleService, this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnBlockBreak(this.bloodmoonService, this.configService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnHarvest(this.bloodmoonService, this.configService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnPlayerItemUse(this.bloodmoonService, this.configService, iMobService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnPlayerCommandPreProcess(this.bloodmoonService, this.configService, iMessageService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnSignCreate(this.bloodmoonService, iMessageService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnPlayerDeath(this.bloodmoonService, iMessageService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnSignBreak(this.bloodmoonService, iMessageService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnSignInteract(this.bloodmoonService, iMessageService), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new OnWorldChange(this.bloodmoonService, iResourcePackService, this.configService), (Plugin)this);
        if (Bukkit.getPluginManager().isPluginEnabled("WildStacker")) {
            Bukkit.getPluginManager().registerEvents((Listener)new WildstackerEventListener(iMobService), (Plugin)this);
        }
        this.getCommand("bloodmoon").setExecutor((CommandExecutor)new BloodmoonCommand(this.bloodmoonService, iMessageService));
        this.getCommand("bloodmoon").setTabCompleter((TabCompleter)new OnTabComplete(this.bloodmoonService, iMobService, iItemService, iLifeCycleService, iActionService, this.configService, iBloodmoonScheduleService));
        BukkitTask bukkitTask = new HeartBeat(this.bloodmoonService, this.configService, iBloodmoonScheduleService, iMessageService, iMobService).runTaskTimer((Plugin)this, 20L, 20L);
        world2 = new SoundTimer(this.bloodmoonService, this.configService, iSoundService).runTaskTimer((Plugin)this, 20L, 20L);
        BukkitTask bukkitTask2 = new NightTimer(this.bloodmoonService, this.configService).runTaskTimer((Plugin)this, 20L, 1L);
        if (this.configService.isUpdateCheckerEnabled()) {
            Runnable runnable = () -> {
                boolean bl = iUpdateService.hasUpdate();
                if (bl) {
                    Bukkit.getLogger().warning(String.format("[bloodmoon-advanced] New update available. You are currently using %s and the latest version is %s", iUpdateService.getCurrentVersion(), iUpdateService.getCachedUpdateVersion()));
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
        this.runFactories();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PapiExtension(this).register();
        }
    }

    void runFactories() {
        SignActionFactory.getFactory().build(this);
        PlayerDeathActionFactory.getFactory().build(this.configService, this.messageService);
    }

    public void onDisable() {
        for (World world : Bukkit.getWorlds()) {
            if (!this.bloodmoonService.bloodmoonIsRunning(world)) continue;
            this.bloodmoonService.stopBloodmoon(world);
        }
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=1717051&resource_id=75095&nonce=-303436006").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

