/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.actions.sign;

import me.mrgeneralq.bloodmoon.defaults.DefaultItem;
import me.mrgeneralq.bloodmoon.interfaces.actions.ISignAction;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Bootstrapper;
import me.mrgeneralq.bloodmoon.statics.Message;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ItemSignAction
implements ISignAction {
    private final Bootstrapper bootstrapper = Bootstrapper.getBootstrapper();
    private final IBloodmoonService bloodmoonService = this.bootstrapper.getBloodmoonService();
    private final IMessageService messageService = this.bootstrapper.getMessageService();
    private final IConfigService configService = this.bootstrapper.getConfigService();
    private final IItemService itemService = this.bootstrapper.getItemService();

    @Override
    public void executeAction(PlayerInteractEvent playerInteractEvent) {
        ItemStack itemStack;
        Player player = playerInteractEvent.getPlayer();
        World world = player.getWorld();
        Sign sign = (Sign)playerInteractEvent.getClickedBlock().getState();
        String[] stringArray = sign.getLines();
        String string = stringArray[2];
        String string2 = String.format("bloodmoon.sign.use.%s", string);
        if (!player.hasPermission(string2)) {
            player.sendMessage(this.messageService.getMessage(Message.signNoPermissionToUse, true));
            return;
        }
        DefaultItem defaultItem = this.itemService.getItem(string);
        if (defaultItem == null && !string.equalsIgnoreCase(Statics.PATH_FINDER_NAME)) {
            player.sendMessage(this.messageService.getMessage(Message.typeNotExists, true).replaceAll("%type%", "item"));
            return;
        }
        Material material = Material.matchMaterial((String)this.configService.getPathMaterial());
        if (defaultItem == null && material == null) {
            return;
        }
        ItemStack itemStack2 = itemStack = defaultItem != null ? defaultItem.getItem() : new ItemStack(material);
        if (defaultItem == null) {
            Statics.setPathFinderMeta(itemStack);
        }
        player.getInventory().addItem(new ItemStack[]{itemStack});
        player.sendMessage(this.messageService.getMessage(Message.itemReceived, true).replaceAll("%player%", "You").replaceAll("%amount%", String.valueOf(itemStack.getAmount())).replaceAll("%type%", defaultItem != null ? defaultItem.getItemId() : "Pathfinder"));
    }

    @Override
    public boolean isValidCreation(SignChangeEvent signChangeEvent) {
        Player player = signChangeEvent.getPlayer();
        String[] stringArray = signChangeEvent.getLines();
        String string = stringArray[2];
        DefaultItem defaultItem = this.itemService.getItem(string);
        if (this.itemService.getItem(string) == null && !string.equalsIgnoreCase(Statics.PATH_FINDER_NAME)) {
            player.sendMessage(this.messageService.getMessage(Message.typeNotExists, true).replaceAll("%type%", "item"));
            return false;
        }
        return true;
    }
}

