/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.actions.sign;

import me.mrgeneralq.bloodmoon.interfaces.actions.ISignAction;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Bootstrapper;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class StartSignAction
implements ISignAction {
    private final Bootstrapper bootstrapper = Bootstrapper.getBootstrapper();
    private final IBloodmoonService bloodmoonService = this.bootstrapper.getBloodmoonService();
    private final IMessageService messageService = this.bootstrapper.getMessageService();
    private final IConfigService configService = this.bootstrapper.getConfigService();

    @Override
    public void executeAction(PlayerInteractEvent playerInteractEvent) {
        Player player = playerInteractEvent.getPlayer();
        World world = player.getWorld();
        if (!this.configService.worldIsEnabled(world)) {
            player.sendMessage(this.messageService.getMessage(Message.worldNotEnabled, true));
            return;
        }
        if (this.bloodmoonService.bloodmoonIsRunning(world)) {
            player.sendMessage(this.messageService.getMessage(Message.bloodmoonAlreadyRunning, true));
            return;
        }
        if (!this.bloodmoonService.isNight(world)) {
            player.sendMessage(this.messageService.getMessage(Message.getMessage(Message.startDay), true));
            return;
        }
        this.bloodmoonService.startBloodmoon(world);
        player.sendMessage(this.messageService.getMessage(Message.getMessage(Message.started), true).replaceAll("%world%", world.getName()));
    }

    @Override
    public boolean isValidCreation(SignChangeEvent signChangeEvent) {
        return true;
    }
}

