/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.api;

import me.mrgeneralq.bloodmoon.defaults.DefaultItem;
import me.mrgeneralq.bloodmoon.defaults.DefaultMob;
import me.mrgeneralq.bloodmoon.enums.DataModification;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IItemService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import me.mrgeneralq.bloodmoon.statics.Bootstrapper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class BloodmoonAPI {
    private static final Bootstrapper bootstrapper = Bootstrapper.getBootstrapper();
    private static final IBloodmoonService bloodmoonService = bootstrapper.getBloodmoonService();
    private static final IConfigService configService = bootstrapper.getConfigService();
    private static final IMobService mobService = bootstrapper.getMobService();
    private static final IItemService itemService = bootstrapper.getItemService();
    private static final IBloodmoonScheduleService scheduleService = bootstrapper.getBloodmoonScheduleService();

    public static boolean bloodmoonIsEnabled(World world) {
        return configService.worldIsEnabled(world);
    }

    public static boolean bloodmoonIsRunning(World world) {
        return bloodmoonService.bloodmoonIsRunning(world);
    }

    public static boolean bloodmoonIsScheduled(World world) {
        return scheduleService.isScheduled(world);
    }

    public static void startBloodmoon(World world) {
        if (!configService.worldIsEnabled(world)) {
            return;
        }
        if (bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        if (!bloodmoonService.isNight(world)) {
            return;
        }
        bloodmoonService.startBloodmoon(world);
    }

    public static void stopBloodmoon(World world) {
        if (!bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        if (!bloodmoonService.isNight(world)) {
            return;
        }
        bloodmoonService.stopBloodmoon(world);
    }

    @Deprecated
    public static void scheduleBloodmoon(World world) {
        BloodmoonAPI.scheduleBloodmoon(world, 5, 100.0);
    }

    public static void scheduleBloodmoon(World world, int n) {
        BloodmoonAPI.scheduleBloodmoon(world, n, 100.0);
    }

    public static void scheduleBloodmoon(World world, int n, double d) {
        if (!configService.worldIsEnabled(world)) {
            return;
        }
        if (bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        if (scheduleService.isScheduled(world)) {
            BloodmoonSchedule bloodmoonSchedule = scheduleService.getSchedule(world);
            bloodmoonSchedule.setDaysLeft(n);
            bloodmoonSchedule.setChance(d);
        } else {
            BloodmoonSchedule bloodmoonSchedule = new BloodmoonSchedule(world, n, d);
            scheduleService.addSchedule(bloodmoonSchedule, DataModification.MEMORY);
        }
    }

    public static void cancelBloodmoon(World world) {
        if (!configService.worldIsEnabled(world)) {
            return;
        }
        if (!scheduleService.isScheduled(world)) {
            return;
        }
        scheduleService.removeSchedule(world, DataModification.MEMORY);
    }

    public static boolean isBloodmoonMob(Entity entity) {
        World world = entity.getWorld();
        Bloodmoon bloodmoon = bloodmoonService.getBloodmoon(world);
        if (bloodmoon == null) {
            return false;
        }
        return bloodmoon.getRegisteredMobs().containsKey(entity.getUniqueId());
    }

    public static void spawnBloodmoonMob(String string, Location location) {
        if (!configService.worldIsEnabled(location.getWorld())) {
            return;
        }
        DefaultMob defaultMob = mobService.getMob(string);
        if (defaultMob == null) {
            Bukkit.getLogger().info(" API: Failed to spawn bloodmoon mob");
            return;
        }
        LivingEntity livingEntity = mobService.spawnMob(location, defaultMob);
        if (bloodmoonService.bloodmoonIsRunning(livingEntity.getWorld())) {
            bloodmoonService.registerMob(livingEntity, livingEntity.getWorld());
        }
    }

    public static void killAllBloodmoonMobs(World world) {
        if (configService.worldIsEnabled(world)) {
            return;
        }
        Bloodmoon bloodmoon = bloodmoonService.getBloodmoon(world);
        if (bloodmoon == null) {
            Bukkit.getLogger().warning("API: unable to kill bloodmoon mobs for bloodmoon object that doesn't exist");
            return;
        }
        bloodmoon.removeMobs(false, null, false, null);
    }

    public static ItemStack getBloodmoonItem(String string) {
        DefaultItem defaultItem = itemService.getItem(string);
        if (defaultItem == null) {
            Bukkit.getLogger().warning("API: Cannot retrieve bloodmoon item");
            return null;
        }
        return defaultItem.getItem();
    }
}

