/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands;

import java.util.Arrays;
import java.util.List;
import me.mrgeneralq.bloodmoon.commands.subcommands.ErrorCommand;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ActionSubCommand
implements ISubCommand {
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;

    public ActionSubCommand(IBloodmoonService iBloodmoonService, IMessageService iMessageService) {
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        if (stringArray.length == 0) {
            if (!commandSender.hasPermission("bloodmoon.action.help")) {
                commandSender.sendMessage(this.messageService.getMessage(Message.noPermission, true));
                return true;
            }
            List<String> list = this.bloodmoonService.getActionCommands();
            Message.showHelpMenu(list, commandSender);
            return true;
        }
        String string2 = stringArray[0];
        if (!commandSender.hasPermission(String.format("bloodmoon.action.%s", string2))) {
            commandSender.sendMessage(this.messageService.getMessage(Message.noPermission, true));
            return true;
        }
        String[] stringArray2 = Arrays.copyOfRange(stringArray, 1, stringArray.length);
        this.bloodmoonService.getActionSubCommands().getOrDefault(string2, new ErrorCommand(this.messageService)).executeCommand(commandSender, command, string, stringArray2);
        return true;
    }
}

