/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands;

import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ButcherSubCommand
implements ISubCommand {
    private final IMessageService messageService;
    private final IBloodmoonService bloodmoonService;

    public ButcherSubCommand(IMessageService iMessageService, IBloodmoonService iBloodmoonService) {
        this.messageService = iMessageService;
        this.bloodmoonService = iBloodmoonService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        Player player = (Player)commandSender;
        World world = player.getWorld();
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            player.sendMessage(this.messageService.getMessage(Message.bloodmoonNotRunning, true));
            return true;
        }
        Bloodmoon bloodmoon = this.bloodmoonService.getBloodmoon(world);
        bloodmoon.removeMobs(false, null, false, null);
        player.sendMessage(this.messageService.getMessage(Message.mobsRemoved, true));
        return true;
    }
}

