/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands;

import java.util.HashMap;
import me.mrgeneralq.bloodmoon.enums.BloodmoonScheduleCause;
import me.mrgeneralq.bloodmoon.enums.DataModification;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import me.mrgeneralq.bloodmoon.statics.Message;
import me.mrgeneralq.bloodmoon.utils.CommandUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class NextSubCommand
implements ISubCommand {
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;
    private final IBloodmoonScheduleService bloodmoonScheduleService;
    private final IConfigService configService;
    private final HashMap<String, ISubCommand> subCommands;

    public NextSubCommand(IBloodmoonService iBloodmoonService, IMessageService iMessageService, IBloodmoonScheduleService iBloodmoonScheduleService, IConfigService iConfigService) {
        this.subCommands = iBloodmoonService.getScheduleSubCommands();
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
        this.bloodmoonScheduleService = iBloodmoonScheduleService;
        this.configService = iConfigService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Object object;
        World world = CommandUtils.getWorldFromCommand(commandSender, stringArray, 1);
        if (world == null) {
            commandSender.sendMessage(this.messageService.getMessage(Message.specifyWorldWhenUsingConsole, true));
            return true;
        }
        Bloodmoon bloodmoon = this.bloodmoonService.getBloodmoon(world);
        int n = 0;
        if (stringArray.length > 0) {
            object = stringArray[0];
            try {
                n = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                commandSender.sendMessage(this.messageService.getMessageHelper(Message.typeNotValid).useConfigMessage().usePrefix().setType("number").getMessage());
                return true;
            }
            if (stringArray.length > 1) {
                if (Bukkit.getWorld((String)stringArray[1]) == null) {
                    commandSender.sendMessage(this.messageService.getMessage(Message.invalidWorld, true));
                    return true;
                }
                world = Bukkit.getWorld((String)stringArray[1]);
            }
        }
        if (!this.configService.worldIsEnabled(world)) {
            commandSender.sendMessage(this.messageService.getMessageHelper(Message.worldNotEnabled).useConfigMessage().usePrefix().setWorld(world.getName()).getMessage());
            return true;
        }
        if (this.bloodmoonService.bloodmoonIsRunning(world)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.bloodmoonAlreadyRunning, true));
            return true;
        }
        if (!this.bloodmoonService.isNight(world) && n == 0) {
            n = -1;
        }
        if (this.bloodmoonScheduleService.isScheduled(world)) {
            object = this.bloodmoonScheduleService.getSchedule(world);
            if (((BloodmoonSchedule)object).isToday()) {
                commandSender.sendMessage(this.messageService.getMessage(Message.alreadyScheduled, true));
                return true;
            }
            ((BloodmoonSchedule)object).setDaysLeft(n);
        } else {
            object = new BloodmoonSchedule(world, n, 100.0);
            this.bloodmoonScheduleService.addSchedule((BloodmoonSchedule)object, DataModification.MEMORY);
        }
        this.bloodmoonScheduleService.callScheduleEvent(bloodmoon, BloodmoonScheduleCause.COMMAND);
        commandSender.sendMessage(this.messageService.getMessageHelper(Message.bloodmoonScheduled).useConfigMessage().usePrefix().setWorld(world.getName()).setDays(String.valueOf(n == -1 ? 0 : n)).getMessage());
        return true;
    }
}

