/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands;

import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import me.mrgeneralq.bloodmoon.utils.CommandUtils;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class StopSubCommand
implements ISubCommand {
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;

    public StopSubCommand(IBloodmoonService iBloodmoonService, IMessageService iMessageService) {
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        World world = CommandUtils.getWorldFromCommand(commandSender, stringArray, 0);
        if (world == null) {
            commandSender.sendMessage(this.messageService.getMessage(Message.specifyWorldWhenUsingConsole, true));
            return true;
        }
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.bloodmoonNotRunning, true));
            return true;
        }
        if (!this.bloodmoonService.isNight(world)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.getMessage(Message.stopDay), true));
            return true;
        }
        this.bloodmoonService.stopBloodmoon(world);
        commandSender.sendMessage(this.messageService.getMessageHelper(Message.stopped).useConfigMessage().usePrefix().setWorld(world.getName()).getMessage());
        return true;
    }
}

