/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.action;

import java.util.List;
import me.mrgeneralq.bloodmoon.defaults.DefaultAction;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.IActionService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ListActionEvents
implements ISubCommand {
    private final IActionService actionService;
    private final IMessageService messageService;

    public ListActionEvents(IActionService iActionService, IMessageService iMessageService) {
        this.actionService = iActionService;
        this.messageService = iMessageService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        Player player = (Player)commandSender;
        if (stringArray.length < 1) {
            player.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("action name").getMessage());
            return true;
        }
        String string2 = stringArray[0];
        DefaultAction defaultAction = this.actionService.getAction(string2);
        if (defaultAction == null) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("action").getMessage());
            return true;
        }
        List<String> list = defaultAction.getEvents();
        if (list.size() == 0) {
            player.sendMessage(this.messageService.getMessageHelper(Message.emptyTypeList).useConfigMessage().usePrefix().setType("action").setSubType("events").getMessage());
            return true;
        }
        player.sendMessage(this.messageService.getMessageHelper(Message.typeList).useConfigMessage().usePrefix().setType("events").getMessage());
        for (int i = 0; i < list.size(); ++i) {
            String string3 = this.messageService.getMessageHelper(Message.listItem).useConfigMessage().setPosition(String.valueOf(i)).setArg(list.get(i)).getMessage();
            player.sendMessage(Message.getMessage(string3));
        }
        return true;
    }
}

