/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.lifecycle;

import java.util.List;
import me.mrgeneralq.bloodmoon.defaults.DefaultLifecycle;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.services.ILifeCycleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RemoveLifeCycleAction
implements ISubCommand {
    private final ILifeCycleService lifeCycleService;
    private final IMessageService messageService;

    public RemoveLifeCycleAction(ILifeCycleService iLifeCycleService, IMessageService iMessageService) {
        this.lifeCycleService = iLifeCycleService;
        this.messageService = iMessageService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        int n;
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        Player player = (Player)commandSender;
        if (stringArray.length < 1) {
            player.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("cycle name").getMessage());
            return true;
        }
        String string2 = stringArray[0];
        DefaultLifecycle defaultLifecycle = this.lifeCycleService.getCycle(string2);
        if (defaultLifecycle == null) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotExists).useConfigMessage().usePrefix().setType("lifecycle").getMessage());
            return true;
        }
        if (stringArray.length < 2) {
            player.sendMessage(this.messageService.getMessageHelper(Message.specifyType).useConfigMessage().usePrefix().setType("action index").getMessage());
            return true;
        }
        try {
            n = Integer.parseInt(stringArray[1]);
        }
        catch (Exception exception) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotValid).useConfigMessage().usePrefix().setType("action index").getMessage());
            return true;
        }
        List<String> list = defaultLifecycle.getActions();
        if (n > list.size() - 1 || n < 0) {
            player.sendMessage(this.messageService.getMessageHelper(Message.typeNotFound).useConfigMessage().usePrefix().setType("Action").getMessage());
            return true;
        }
        String string3 = defaultLifecycle.getActions().get(n);
        defaultLifecycle.removeAction(n);
        this.lifeCycleService.updateCycle(defaultLifecycle);
        player.sendMessage(this.messageService.getMessageHelper(Message.typeRemoved).useConfigMessage().usePrefix().setType(string3).getMessage());
        return true;
    }
}

