/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.commands.subcommands.schedule;

import me.mrgeneralq.bloodmoon.enums.DataModification;
import me.mrgeneralq.bloodmoon.interfaces.ISubCommand;
import me.mrgeneralq.bloodmoon.interfaces.commandproperties.IScheduleCommandProperty;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonScheduleService;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.models.BloodmoonSchedule;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ScheduleSetPropertyCommand
implements ISubCommand {
    private final IBloodmoonScheduleService scheduleService;
    private final IBloodmoonService bloodmoonService;
    private final IMessageService messageService;

    public ScheduleSetPropertyCommand(IBloodmoonScheduleService iBloodmoonScheduleService, IBloodmoonService iBloodmoonService, IMessageService iMessageService) {
        this.scheduleService = iBloodmoonScheduleService;
        this.bloodmoonService = iBloodmoonService;
        this.messageService = iMessageService;
    }

    @Override
    public boolean executeCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(this.messageService.getMessage(Message.commandOnlyForPlayers, true));
            return true;
        }
        Player player = (Player)commandSender;
        if (stringArray.length < 1) {
            player.sendMessage(this.messageService.getMessage(Message.specifyType, true).replaceAll("%type%", "property"));
            return true;
        }
        String string2 = stringArray[0];
        IScheduleCommandProperty iScheduleCommandProperty = this.bloodmoonService.getScheduleCommandProperties().getOrDefault(string2, null);
        if (iScheduleCommandProperty == null) {
            player.sendMessage(this.messageService.getMessage(Message.typeNotValid, true).replaceAll("%type%", "property"));
            return true;
        }
        if (stringArray.length < 2) {
            player.sendMessage(this.messageService.getMessage(Message.specifyType, true).replaceAll("%type%", "world name"));
            return true;
        }
        String string3 = stringArray[1];
        BloodmoonSchedule bloodmoonSchedule = this.scheduleService.getScheduleFromRepo(string3);
        if (bloodmoonSchedule == null) {
            player.sendMessage(this.messageService.getMessage(Message.typeNotExists, true).replaceAll("%type%", "schedule"));
            return true;
        }
        if (stringArray.length < 3) {
            player.sendMessage(this.messageService.getMessage(Message.specifyType, true).replaceAll("%type%", "value"));
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 2; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]).append(" ");
        }
        if (!iScheduleCommandProperty.isValidPropertyValue(stringBuilder.toString().trim())) {
            player.sendMessage(this.messageService.getMessage(Message.typeNotValid, true).replaceAll("%type%", "value"));
            player.sendMessage(Message.getMessage(String.format("Use: %s", iScheduleCommandProperty.getPropertyUsage())));
            return true;
        }
        iScheduleCommandProperty.setValue(bloodmoonSchedule);
        this.scheduleService.addSchedule(bloodmoonSchedule, DataModification.ALL);
        player.sendMessage(this.messageService.getMessage(Message.typeUpdated, true).replaceAll("%type%", bloodmoonSchedule.getWorld().getName()));
        return true;
    }
}

