/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.Arrays;
import me.mrgeneralq.bloodmoon.events.BloodmoonStopEvent;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import me.mrgeneralq.bloodmoon.interfaces.services.ISoundService;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class OnBloodmoonStop
implements Listener {
    private IBloodmoonService bloodmoonService;
    private IConfigService configService;
    private final IMessageService messageService;
    private final ISoundService soundService;

    public OnBloodmoonStop(IBloodmoonService iBloodmoonService, IConfigService iConfigService, IMessageService iMessageService, ISoundService iSoundService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
        this.messageService = iMessageService;
        this.soundService = iSoundService;
    }

    @EventHandler
    public void onBloodmoonStop(BloodmoonStopEvent bloodmoonStopEvent) {
        Object object;
        Bloodmoon bloodmoon = bloodmoonStopEvent.getBloodmoon();
        World world = bloodmoon.getWorld();
        if (this.configService.isChangeDifficulty()) {
            bloodmoon.resetDifficulty();
        }
        if (this.configService.isStopSoundEnabled()) {
            object = this.configService.getStopSound();
            for (Object object2 : bloodmoonStopEvent.getBloodmoon().getWorld().getPlayers()) {
                this.soundService.playSound((Player)object2, (String)object);
            }
        }
        if (this.configService.isRunStopCommands()) {
            for (String string : this.configService.getStopCommands()) {
                Object object2;
                object2 = Bukkit.getServer().getConsoleSender();
                if (string.toLowerCase().startsWith("bloodmoon say ")) {
                    Object object3 = string.replaceAll("%world%", world.getName()).split(" ");
                    Player player = (Player)Arrays.copyOfRange(object3, 2, ((Object)object3).length);
                    this.messageService.broadcast(bloodmoon.getWorld(), String.join((CharSequence)" ", (CharSequence[])player));
                    continue;
                }
                if (string.contains("%player%")) {
                    for (Player player : world.getPlayers()) {
                        Bukkit.dispatchCommand((CommandSender)object2, (String)string.replaceAll("%player%", player.getDisplayName()).replaceAll("%world%", world.getName()));
                    }
                    continue;
                }
                Bukkit.dispatchCommand((CommandSender)object2, (String)string.replaceAll("%world%", world.getName()));
            }
        }
        if (this.configService.isSetResourcePack()) {
            bloodmoon.setResourcePackEnabled(false);
        }
        if (this.configService.stopTitleEnabled()) {
            object = this.configService.getStopTitle();
            String string = this.configService.getStopSubTitle();
            for (Object object3 : world.getPlayers()) {
                object3.sendTitle(Message.getMessage((String)object), string, 10, 70, 20);
            }
        }
        bloodmoon.getBossbar().setVisible(false);
    }
}

