/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class OnHarvest
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;
    private final List<Material> crops;
    private final HashMap<Material, ItemStack> drops;

    public OnHarvest(IBloodmoonService iBloodmoonService, IConfigService iConfigService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
        this.crops = Stream.of(Material.matchMaterial((String)"BEETROOTS"), Material.matchMaterial((String)"CARROTS"), Material.matchMaterial((String)"POTATOES"), Material.matchMaterial((String)"WHEAT")).filter(material -> material != null).filter(Objects::nonNull).collect(Collectors.toList());
        this.drops = new HashMap();
        if (Material.matchMaterial((String)"BEETROOT_SEEDS") != null) {
            this.drops.put(Material.matchMaterial((String)"BEETROOTS"), new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)"BEETROOT_SEEDS"))));
        }
        this.drops.put(Material.matchMaterial((String)"CARROTS"), new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)"CARROT"))));
        this.drops.put(Material.matchMaterial((String)"POTATOES"), new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)"POISONOUS_POTATO"))));
        if (Material.matchMaterial((String)"WHEAT_SEEDS") != null) {
            this.drops.put(Material.matchMaterial((String)"WHEAT"), new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)"WHEAT_SEEDS"))));
        } else {
            this.drops.put(Material.matchMaterial((String)"WHEAT"), new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)"SEEDS"))));
        }
    }

    @EventHandler
    public void onHarvest(BlockBreakEvent blockBreakEvent) {
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        Block block = blockBreakEvent.getBlock();
        if (!this.bloodmoonService.bloodmoonIsRunning(block.getWorld())) {
            return;
        }
        if (!this.crops.contains(block.getType())) {
            return;
        }
        if (block.getDrops().size() == 0) {
            return;
        }
        double d = new Random().nextDouble() * 100.0;
        if (d <= this.configService.getHarvestChance()) {
            ItemStack itemStack = this.drops.get(block.getType());
            if (block.getType() != Material.matchMaterial((String)"CARROTS")) {
                int n = 1;
                for (ItemStack itemStack2 : block.getDrops()) {
                    if (itemStack2.getType() != itemStack.getType()) continue;
                    n = itemStack2.getAmount();
                    break;
                }
                itemStack.setAmount(new Random().nextInt(n) + 1);
            }
            blockBreakEvent.setDropItems(false);
            block.getWorld().dropItem(block.getLocation(), itemStack);
        }
    }
}

