/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.List;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class OnMobSpawn
implements Listener {
    private IBloodmoonService bloodmoonService;
    private IConfigService configService;

    public OnMobSpawn(IBloodmoonService iBloodmoonService, IConfigService iConfigService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        if (creatureSpawnEvent.isCancelled()) {
            return;
        }
        LivingEntity livingEntity = creatureSpawnEvent.getEntity();
        World world = livingEntity.getWorld();
        if (creatureSpawnEvent.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SLIME_SPLIT && this.bloodmoonService.bloodmoonIsRunning(world)) {
            this.bloodmoonService.registerMob(livingEntity, world);
            return;
        }
        if (this.configService.getSpawningEnabled()) {
            return;
        }
        CreatureSpawnEvent.SpawnReason spawnReason = creatureSpawnEvent.getSpawnReason();
        if (spawnReason == CreatureSpawnEvent.SpawnReason.CUSTOM) {
            return;
        }
        try {
            if (spawnReason == CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.configService.naturalDisabled() && spawnReason == CreatureSpawnEvent.SpawnReason.valueOf((String)"NATURAL")) {
                return;
            }
            if (this.configService.spawnerDisabled() && spawnReason == CreatureSpawnEvent.SpawnReason.valueOf((String)"SPAWNER")) {
                return;
            }
            if (this.configService.egssDisabled() && (spawnReason == CreatureSpawnEvent.SpawnReason.valueOf((String)"EGG") || spawnReason == CreatureSpawnEvent.SpawnReason.valueOf((String)"DISPENSE_EGG") || spawnReason == CreatureSpawnEvent.SpawnReason.valueOf((String)"SPAWNER_EGG"))) {
                return;
            }
            if (this.configService.ironGolemDisabled() && spawnReason == CreatureSpawnEvent.SpawnReason.valueOf((String)"BUILD_IRONGOLEM")) {
                return;
            }
            if (this.configService.snowmanDisabled() && spawnReason == CreatureSpawnEvent.SpawnReason.valueOf((String)"BUILD_SNOWMAN")) {
                return;
            }
            if (this.configService.witherDisabled() && spawnReason == CreatureSpawnEvent.SpawnReason.valueOf((String)"BUILD_WITHER")) {
                return;
            }
            if (this.configService.breedingDisabled() && spawnReason == CreatureSpawnEvent.SpawnReason.valueOf((String)"BREEDING")) {
                return;
            }
            if (this.configService.beesDisabled() && spawnReason == CreatureSpawnEvent.SpawnReason.valueOf((String)"BEEHIVE")) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        if (!(livingEntity instanceof Monster)) {
            return;
        }
        List list = this.configService.getExcludedMobs().stream().map(Statics::getEntityType).collect(Collectors.toList());
        if (list.contains(livingEntity.getType())) {
            return;
        }
        this.bloodmoonService.replaceMob(livingEntity);
    }
}

