/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.List;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class OnPlayerCommandPreProcess
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;
    private final IMessageService messageService;

    public OnPlayerCommandPreProcess(IBloodmoonService iBloodmoonService, IConfigService iConfigService, IMessageService iMessageService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
        this.messageService = iMessageService;
    }

    @EventHandler
    public void onPlayerCommandPreprocessEvent(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        String string = playerCommandPreprocessEvent.getMessage().substring(1);
        Player player = playerCommandPreprocessEvent.getPlayer();
        World world = player.getWorld();
        if (!this.bloodmoonService.bloodmoonIsRunning(world)) {
            return;
        }
        List<String> list = this.configService.getBlockedCommands();
        if (list.size() == 0) {
            return;
        }
        if (player.hasPermission("bloodmoon.bypass.blocked-cmds")) {
            return;
        }
        for (String string2 : list) {
            if (!string.toLowerCase().startsWith(string2.toLowerCase())) continue;
            player.sendMessage(this.messageService.getMessage("command-blocked", true));
            playerCommandPreprocessEvent.setCancelled(true);
        }
    }
}

