/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.eventlisteners;

import java.util.List;
import java.util.stream.Collectors;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.statics.Statics;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.scheduler.BukkitRunnable;

public class OnPlayerItemUse
implements Listener {
    private final IBloodmoonService bloodmoonService;
    private final IConfigService configService;
    private final IMobService mobService;

    public OnPlayerItemUse(IBloodmoonService iBloodmoonService, IConfigService iConfigService, IMobService iMobService) {
        this.bloodmoonService = iBloodmoonService;
        this.configService = iConfigService;
        this.mobService = iMobService;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        if (!this.bloodmoonService.bloodmoonIsRunning(playerInteractEvent.getPlayer().getWorld())) {
            return;
        }
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        final Player player = playerInteractEvent.getPlayer();
        Location location = player.getLocation();
        double d = location.getX();
        double d2 = location.getZ();
        player.getWorld().getEntities();
        List list = player.getWorld().getEntities().stream().filter(entity -> entity.getMetadata("mobID").size() >= 1 && ((MetadataValue)entity.getMetadata("mobID").get(0)).asBoolean()).collect(Collectors.toList());
        if (list.size() > 0) {
            ItemStack itemStack;
            List list2 = list.stream().sorted((entity, entity2) -> Statics.bigger(entity, entity2, d, d2)).collect(Collectors.toList());
            final LivingEntity livingEntity = (LivingEntity)list2.get(0);
            try {
                itemStack = player.getInventory().getItemInMainHand();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                itemStack = player.getItemInHand();
            }
            Material material = Material.matchMaterial((String)this.configService.getPathMaterial());
            if (material == null) {
                return;
            }
            ItemStack itemStack2 = new ItemStack(material);
            Statics.setPathFinderMeta(itemStack2);
            if (player.hasPermission("bloodmoon.pathfinder") && itemStack2.isSimilar(itemStack) && this.mobService.canUsePath(player)) {
                this.mobService.addPathDelay(player);
                new BukkitRunnable(){
                    int i = 0;

                    public void run() {
                        double d = livingEntity.getLocation().getX() - player.getLocation().getX();
                        d /= Math.abs(d);
                        double d2 = player.getLocation().getX() + (double)this.i * d;
                        double d3 = Statics.linearInterpolation(player.getLocation().getX(), player.getLocation().getZ(), livingEntity.getLocation().getX(), livingEntity.getLocation().getZ(), d2);
                        Location location = new Location(player.getWorld(), d2, player.getLocation().getY() + 1.2, d3);
                        player.getWorld().spawnParticle(Particle.DRIP_LAVA, location, 1);
                        ++this.i;
                        if (this.i >= 6) {
                            this.cancel();
                        }
                    }
                }.runTaskTimer(this.mobService.getPlugin(), 0L, 3L);
                playerInteractEvent.setCancelled(true);
            }
        }
    }
}

