/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.factories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.mrgeneralq.bloodmoon.actions.playerdeath.ClearInventoryDeathAction;
import me.mrgeneralq.bloodmoon.actions.playerdeath.CommandDeathAction;
import me.mrgeneralq.bloodmoon.actions.playerdeath.LoseXpPlayerDeathAction;
import me.mrgeneralq.bloodmoon.interfaces.actions.IPlayerDeathAction;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMessageService;

public class PlayerDeathActionFactory {
    private static PlayerDeathActionFactory instance;
    private IConfigService configService;
    private IMessageService messageService;
    private HashMap<String, IPlayerDeathAction> actionList = new HashMap();

    public static PlayerDeathActionFactory getFactory() {
        if (instance == null) {
            instance = new PlayerDeathActionFactory();
        }
        return instance;
    }

    private PlayerDeathActionFactory() {
    }

    public void build(IConfigService iConfigService, IMessageService iMessageService) {
        this.actionList = new HashMap();
        this.configService = iConfigService;
        this.messageService = iMessageService;
        this.actionList.put("lose-xp", new LoseXpPlayerDeathAction("lose-xp"));
        this.actionList.put("clear-inventory", new ClearInventoryDeathAction("clear-inventory"));
        for (String string : this.configService.getDeathCommand()) {
            String[] stringArray = string.split(" ");
            String string2 = stringArray[stringArray.length - 1];
            double d = 100.0;
            try {
                d = Double.parseDouble(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.actionList.put("commands", new CommandDeathAction(iMessageService, string, d));
        }
    }

    public IPlayerDeathAction getAction(String string) {
        return this.actionList.get(string);
    }

    public boolean actionExists(String string) {
        return this.actionList.containsKey(string);
    }

    public List<String> getAllActionKeys() {
        return new ArrayList<String>(this.actionList.keySet());
    }
}

