/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.models;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;

@SerializableAs(value="BloodmoonSchedule")
public class BloodmoonSchedule
implements ConfigurationSerializable {
    World world;
    int totalDays = 5;
    boolean randomDays = true;
    boolean isRepeating = true;
    double chance = 100.0;
    boolean isBroadcasting = true;
    String daysLeftMessage = "%days-left% days left until the next bloodmoon";
    String tonightMessage = "Tonight will be a possible bloodmoon!";
    int daysLeft = 0;

    public BloodmoonSchedule(Map<String, Object> map) {
        this.totalDays = (Integer)map.getOrDefault("days", 5);
        this.isRepeating = (Boolean)map.getOrDefault("repeating", true);
        this.chance = (Double)map.getOrDefault("chance", 100.0);
        this.isBroadcasting = (Boolean)map.getOrDefault("broadcast", true);
        this.daysLeftMessage = (String)map.getOrDefault("days-left-message", "%days-left% days left until the next bloodmoon");
        this.tonightMessage = (String)map.getOrDefault("tonight-message", "Tonight will be a possible bloodmoon!");
        this.randomDays = (Boolean)map.getOrDefault("random-days", true);
        this.daysLeft = this.randomDays ? new Random().nextInt(this.totalDays) : this.totalDays;
    }

    public BloodmoonSchedule(World world) {
        this.world = world;
    }

    public BloodmoonSchedule(World world, int n, double d) {
        this.world = world;
        this.isRepeating = false;
        this.randomDays = false;
        this.daysLeft = n;
        this.chance = d;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("days", this.totalDays);
        hashMap.put("random-days", this.randomDays);
        hashMap.put("repeating", this.isRepeating);
        hashMap.put("chance", this.chance);
        hashMap.put("broadcast", this.isBroadcasting);
        hashMap.put("days-left-message", this.daysLeftMessage);
        hashMap.put("tonight-message", this.tonightMessage);
        return hashMap;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public int getTotalDays() {
        return this.totalDays;
    }

    public void setTotalDays(int n) {
        this.totalDays = n;
    }

    public boolean isRepeating() {
        return this.isRepeating;
    }

    public void setRepeating(boolean bl) {
        this.isRepeating = bl;
    }

    public double getChance() {
        return this.chance;
    }

    public void setChance(double d) {
        this.chance = d;
    }

    public boolean isBroadcasting() {
        return this.isBroadcasting;
    }

    public void setBroadcasting(boolean bl) {
        this.isBroadcasting = bl;
    }

    public String getDaysLeftMessage() {
        return this.daysLeftMessage;
    }

    public void setDaysLeftMessage(String string) {
        this.daysLeftMessage = string;
    }

    public int getDaysLeft() {
        return this.daysLeft + 1;
    }

    public void setDaysLeft(int n) {
        this.daysLeft = n;
    }

    public boolean isToday() {
        return this.daysLeft < 0;
    }

    public void progress() {
        --this.daysLeft;
    }

    public void repeat() {
        if (this.randomDays) {
            this.daysLeft = new Random().nextInt(this.totalDays);
            return;
        }
        this.daysLeft = this.totalDays;
    }

    public boolean isRandomDays() {
        return this.randomDays;
    }

    public void setRandomDays(boolean bl) {
        this.randomDays = bl;
    }

    public String getTonightMessage() {
        return this.tonightMessage;
    }

    public void setTonightMessage(String string) {
        this.tonightMessage = string;
    }
}

