/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.repositories;

import java.util.Map;
import java.util.Set;
import me.mrgeneralq.bloodmoon.defaults.DefaultAction;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IActionRepository;
import me.mrgeneralq.bloodmoon.statics.ConfigManager;
import me.mrgeneralq.bloodmoon.statics.YamlManager;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class ActionRepository
implements IActionRepository {
    private YamlConfiguration config;
    private final ConfigManager configManager = ConfigManager.getManager();
    private YamlManager yaml;

    public ActionRepository() {
        this.config = this.configManager.getConfig("actions");
        this.yaml = YamlManager.getYaml();
    }

    @Override
    public DefaultAction get(String string) {
        DefaultAction defaultAction;
        if (!this.yaml.exists(this.config, this.getActionPath(string))) {
            return null;
        }
        ConfigurationSection configurationSection = this.config.getConfigurationSection(this.getActionPath(string));
        if (configurationSection == null) {
            Map map = (Map)this.config.get(this.getActionPath(string));
            defaultAction = new DefaultAction(map);
        } else {
            Map map = configurationSection.getValues(false);
            defaultAction = new DefaultAction(map);
        }
        defaultAction.setID(string);
        return defaultAction;
    }

    @Override
    public void addOrUpdate(DefaultAction defaultAction) {
        this.config.set(this.getActionPath(defaultAction.getID()), defaultAction.serialize());
        this.configManager.saveConfig(this.config, "actions");
    }

    @Override
    public Set<String> getSectionList(String string) {
        return this.config.getConfigurationSection(string).getKeys(false);
    }

    @Override
    public void remove(String string) {
        this.config.set(String.format("actions.%s", string), null);
        this.configManager.saveConfig(this.config, "actions");
    }

    @Override
    public void reloadConfig() {
        this.config = this.configManager.reloadConfig("actions");
    }

    private String getActionPath(String string) {
        return String.format("actions.%s", string);
    }
}

