/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.repositories;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IBloodmoonRepository;
import me.mrgeneralq.bloodmoon.models.Bloodmoon;
import me.mrgeneralq.bloodmoon.statics.Tuple;

public class BloodmoonRepository
implements IBloodmoonRepository {
    private HashMap<UUID, Bloodmoon> bloodmoonList = new HashMap();
    private HashMap<UUID, Date> activeShields = new HashMap();

    @Override
    public void addOrUpdate(Bloodmoon bloodmoon) {
        this.bloodmoonList.put(bloodmoon.getWorld().getUID(), bloodmoon);
    }

    @Override
    public void remove(Bloodmoon bloodmoon) {
        this.bloodmoonList.remove(bloodmoon.getWorld().getUID());
    }

    @Override
    public Bloodmoon get(UUID uUID) {
        return this.bloodmoonList.getOrDefault(uUID, null);
    }

    @Override
    public boolean exists(UUID uUID) {
        return this.bloodmoonList.containsKey(uUID);
    }

    @Override
    public List<Bloodmoon> getAll() {
        return new ArrayList<Bloodmoon>(this.bloodmoonList.values());
    }

    @Override
    public void reloadConfig() {
    }

    @Override
    public void addActiveShield(UUID uUID) {
        this.activeShields.put(uUID, new Date());
    }

    @Override
    public HashMap<UUID, Date> getActiveShields() {
        return this.activeShields;
    }

    @Override
    public Tuple<UUID, Date> getActiveShield(UUID uUID) {
        Tuple<UUID, Object> tuple = new Tuple<UUID, Object>(uUID, null);
        tuple.setSecond(this.activeShields.getOrDefault(uUID, new Date()));
        return tuple;
    }

    @Override
    public void checkActiveShield(UUID uUID, int n) {
        Date date = this.activeShields.getOrDefault(uUID, new Date());
        long l = (new Date().getTime() - date.getTime()) / 1000L;
        if (l > (long)n) {
            this.activeShields.remove(uUID);
        }
    }

    @Override
    public void resetActiveShields() {
        this.activeShields.clear();
    }
}

