/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.repositories;

import java.util.Set;
import me.mrgeneralq.bloodmoon.BloodmoonCore;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IConfigRepository;

public class ConfigRepository
implements IConfigRepository {
    private final BloodmoonCore bloodmoonCore;

    public ConfigRepository(BloodmoonCore bloodmoonCore) {
        this.bloodmoonCore = bloodmoonCore;
    }

    @Override
    public Object getProperty(String string) {
        return this.bloodmoonCore.getConfig().get(string);
    }

    @Override
    public Object getPropertyOrDefault(String string, Object object) {
        if (!this.exists(string)) {
            return object;
        }
        return this.getProperty(string);
    }

    @Override
    public void addOrUpdateProperty(String string, Object object) {
        this.bloodmoonCore.getConfig().set(string, object);
        this.bloodmoonCore.saveConfig();
    }

    @Override
    public void removeProperty(String string) {
        this.bloodmoonCore.getConfig().set(string, null);
        this.bloodmoonCore.saveConfig();
    }

    @Override
    public boolean exists(String string) {
        return this.bloodmoonCore.getConfig().isSet(string);
    }

    @Override
    public Set<String> getSection(String string) {
        return this.bloodmoonCore.getConfig().getConfigurationSection(string).getKeys(false);
    }

    @Override
    public void reloadConfig() {
        this.bloodmoonCore.reloadConfig();
    }
}

