/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.services;

import java.util.HashMap;
import java.util.UUID;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class BossbarService {
    private final HashMap<UUID, BossBar> bossbarMemory = new HashMap();
    private final IConfigService configService;

    public BossbarService(IConfigService iConfigService) {
        this.configService = iConfigService;
    }

    public void setVisible(Player player, boolean bl) {
        BossBar bossBar = this.getBossbar(player);
        bossBar.setVisible(bl);
    }

    public void update(Player player, BossBar bossBar) {
        this.bossbarMemory.put(player.getUniqueId(), bossBar);
    }

    public void removeBossbar(Player player) {
        this.bossbarMemory.remove(player.getUniqueId());
    }

    public void initializeBossbar(Player player) {
        BossBar bossBar = Bukkit.createBossBar((String)this.configService.getBossbarTitle(), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        if (this.configService.bossBarFogEnabled()) {
            bossBar.addFlag(BarFlag.CREATE_FOG);
        }
        if (this.configService.isBossbarDarkEnabled()) {
            bossBar.addFlag(BarFlag.DARKEN_SKY);
        }
        bossBar.addPlayer(player);
        this.update(player, bossBar);
    }

    public BossBar getBossbar(Player player) {
        if (!this.bossbarMemory.containsKey(player.getUniqueId())) {
            this.initializeBossbar(player);
        }
        return this.bossbarMemory.get(player.getUniqueId());
    }
}

