/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.services;

import java.util.ArrayList;
import java.util.List;
import me.mrgeneralq.bloodmoon.interfaces.repositories.IConfigRepository;
import me.mrgeneralq.bloodmoon.interfaces.services.IConfigService;
import me.mrgeneralq.bloodmoon.models.MobBlock;
import me.mrgeneralq.bloodmoon.models.configblock.DeathActionConfigBlock;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.EntityType;

public class ConfigService
implements IConfigService {
    private final IConfigRepository configRepository;
    private String VERSION = "3.5";

    public ConfigService(IConfigRepository iConfigRepository) {
        this.configRepository = iConfigRepository;
    }

    @Override
    public boolean isChangeDifficulty() {
        return (Boolean)this.configRepository.getProperty("change-difficulty");
    }

    @Override
    public Difficulty getDifficulty() {
        String string = (String)this.configRepository.getProperty("difficulty");
        switch (string.toLowerCase()) {
            case "easy": {
                return Difficulty.EASY;
            }
            case "normal": {
                return Difficulty.NORMAL;
            }
            case "peaceful": {
                return Difficulty.PEACEFUL;
            }
        }
        return Difficulty.HARD;
    }

    @Override
    public boolean isPortalDisabled() {
        return (Boolean)this.configRepository.getProperty("block-portal");
    }

    @Override
    public boolean isSleepingDisabled() {
        return (Boolean)this.configRepository.getProperty("block-sleeping");
    }

    @Override
    public boolean worldIsEnabled(World world) {
        List list = (List)this.configRepository.getProperty("enabled-worlds");
        return list.contains(world.getName());
    }

    @Override
    public int getChargedCreeperChance() {
        return (Integer)this.configRepository.getProperty("charged-creeper-chance");
    }

    @Override
    @Deprecated
    public double getBloodmoonChance() {
        return (Double)this.configRepository.getPropertyOrDefault("bloodmoon-chance", 0);
    }

    @Override
    public double getLightningStrikeChance() {
        try {
            return (Double)this.configRepository.getProperty("lightning-strike-player-chance");
        }
        catch (Exception exception) {
            return ((Integer)this.configRepository.getProperty("lightning-strike-player-chance")).intValue();
        }
    }

    @Override
    public MobBlock getMobBlock(Material material) {
        double d;
        String string = material.toString();
        String string2 = (String)this.configRepository.getProperty(String.format("mob-in-block.blocks.%s.mob", string));
        try {
            d = (Double)this.configRepository.getProperty(String.format("mob-in-block.blocks.%s.percentage", string));
        }
        catch (Exception exception) {
            d = ((Integer)this.configRepository.getProperty(String.format("mob-in-block.blocks.%s.percentage", string))).intValue();
        }
        return new MobBlock(EntityType.valueOf((String)string2), Material.getMaterial((String)string), d);
    }

    @Override
    public boolean isMobBlockEnabled() {
        return (Boolean)this.configRepository.getProperty("mob-in-block.enabled");
    }

    @Override
    public boolean mobBlockExists(Material material) {
        String string = material.toString();
        return this.configRepository.exists(String.format("mob-in-block.blocks.%s", string));
    }

    @Override
    public List<String> getStartCommands() {
        return (List)this.configRepository.getProperty("start-actions.commands.commands");
    }

    @Override
    public String getStartTitle() {
        return Message.getMessage((String)this.configRepository.getProperty("start-actions.title.title"));
    }

    @Override
    public String getStopTitle() {
        return Message.getMessage((String)this.configRepository.getProperty("stop-actions.title.title"));
    }

    @Override
    public String getStartSubTitle() {
        return Message.getMessage((String)this.configRepository.getProperty("start-actions.title.subtitle"));
    }

    @Override
    public String getStopSubTitle() {
        return Message.getMessage((String)this.configRepository.getProperty("stop-actions.title.subtitle"));
    }

    @Override
    public boolean startTitleEnabled() {
        return (Boolean)this.configRepository.getProperty("start-actions.title.enabled");
    }

    @Override
    public boolean stopTitleEnabled() {
        return (Boolean)this.configRepository.getProperty("stop-actions.title.enabled");
    }

    @Override
    public boolean isRunStartCommands() {
        return (Boolean)this.configRepository.getProperty("start-actions.commands.enabled");
    }

    @Override
    public List<String> getStopCommands() {
        return (List)this.configRepository.getProperty("stop-actions.commands.commands");
    }

    @Override
    public boolean isRunStopCommands() {
        return (Boolean)this.configRepository.getProperty("stop-actions.commands.enabled");
    }

    @Override
    public boolean isRunBell() {
        return (Boolean)this.configRepository.getProperty("bell-warning.enabled");
    }

    @Override
    public int getBellCount() {
        return (Integer)this.configRepository.getProperty("bell-warning.count");
    }

    @Override
    public boolean isPlayDespawnSound() {
        return (Boolean)this.configRepository.getProperty("mob-despawn-effect.play-sound.enabled");
    }

    @Override
    public boolean isPlayDespawnParticle() {
        return (Boolean)this.configRepository.getProperty("mob-despawn-effect.play-particle.enabled");
    }

    @Override
    public Sound getDespawnSound() {
        return Sound.valueOf((String)((String)this.configRepository.getProperty("mob-despawn-effect.play-sound.sound")));
    }

    @Override
    public Particle getDespawnParticle() {
        return Particle.valueOf((String)((String)this.configRepository.getProperty("mob-despawn-effect.play-particle.particle")));
    }

    @Override
    public boolean isSetResourcePack() {
        return (Boolean)this.configRepository.getProperty("resource-pack.enabled");
    }

    @Override
    public String getResourcePackURL(boolean bl) {
        String string = bl ? "enabled" : "disabled";
        return (String)this.configRepository.getProperty("resource-pack.url-" + string);
    }

    @Override
    public void reloadConfig() {
        this.configRepository.reloadConfig();
    }

    @Override
    public double getHarvestChance() {
        try {
            return (Double)this.configRepository.getProperty("harvest-failure-chance");
        }
        catch (Exception exception) {
            return ((Integer)this.configRepository.getProperty("harvest-failure-chance")).intValue();
        }
    }

    @Override
    public boolean compassEnabled() {
        return (Boolean)this.configRepository.getProperty("paths.compass");
    }

    @Override
    public List<String> getExcludedMobs() {
        return (List)this.configRepository.getProperty("excluded-mobs");
    }

    @Override
    public int getMonsterLimit() {
        return (Integer)this.configRepository.getProperty("monster-spawn-limit");
    }

    @Override
    public boolean isBossbarEnabled() {
        return (Boolean)this.configRepository.getProperty("bossbar.enabled");
    }

    @Override
    public boolean isBossbarDarkEnabled() {
        return (Boolean)this.configRepository.getProperty("bossbar.dark");
    }

    @Override
    public boolean bossBarFogEnabled() {
        return (Boolean)this.configRepository.getProperty("bossbar.fog");
    }

    @Override
    public String getBossbarTitle() {
        return Message.getMessage((String)this.configRepository.getProperty("bossbar.title"));
    }

    @Override
    public boolean scarySoundsEnabled() {
        return (Boolean)this.configRepository.getProperty("scary-sounds.enabled");
    }

    @Override
    public List<String> getScarySounds() {
        return (List)this.configRepository.getProperty("scary-sounds.sounds");
    }

    @Override
    public boolean isStartSoundEnabled() {
        return (Boolean)this.configRepository.getProperty("start-actions.sound.enabled");
    }

    @Override
    public boolean isStopSoundEnabled() {
        return (Boolean)this.configRepository.getProperty("stop-actions.sound.enabled");
    }

    @Override
    public String getStartSound() {
        return (String)this.configRepository.getProperty("start-actions.sound.start-sound");
    }

    @Override
    public String getStopSound() {
        return (String)this.configRepository.getProperty("stop-actions.sound.stop-sound");
    }

    @Override
    public String getConfigVersion() {
        return (String)this.configRepository.getPropertyOrDefault("version", "not found");
    }

    @Override
    public String getCurrentVersion() {
        return this.VERSION;
    }

    @Override
    public boolean isUpdateCheckerEnabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("update-checker-enabled", true);
    }

    @Override
    public boolean spawnerDisabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("excluded-spawn-methods.spawners", false);
    }

    @Override
    public boolean naturalDisabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("excluded-spawn-methods.natural", false);
    }

    @Override
    public boolean egssDisabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("excluded-spawn-methods.eggs", false);
    }

    @Override
    public boolean ironGolemDisabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("excluded-spawn-methods.iron-golem", false);
    }

    @Override
    public boolean snowmanDisabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("excluded-spawn-methods.snownman", false);
    }

    @Override
    public boolean witherDisabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("excluded-spawn-methods.wither", false);
    }

    @Override
    public boolean breedingDisabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("excluded-spawn-methods.breeding", false);
    }

    @Override
    public boolean beesDisabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("excluded-spawn-methods.bees", false);
    }

    @Override
    public double getBossChance() {
        return (Double)this.configRepository.getPropertyOrDefault("boss.chance", 100.0);
    }

    @Override
    public boolean bossEnabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("boss.enabled", true);
    }

    @Override
    public boolean bossBossBarEnabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("boss.bossbar", true);
    }

    @Override
    public int getPathDelay() {
        return (Integer)this.configRepository.getPropertyOrDefault("paths.delay", 5);
    }

    @Override
    public String getPathMaterial() {
        return (String)this.configRepository.getPropertyOrDefault("paths.material", "COMPASS");
    }

    @Override
    public List<String> getBlockedCommands() {
        return (List)this.configRepository.getPropertyOrDefault("blocked-commands", new ArrayList());
    }

    @Override
    public DeathActionConfigBlock getDeathActionConfigBlock(String string) {
        DeathActionConfigBlock deathActionConfigBlock = new DeathActionConfigBlock(string);
        String string2 = String.format("death-actions.%s.%s", string, "chance");
        double d = 0.0;
        try {
            d = (Double)this.configRepository.getPropertyOrDefault(string2, 0.0);
            deathActionConfigBlock.setPercentage(d);
        }
        catch (Exception exception) {
            Bukkit.getLogger().warning("There was an issue parsing the percentage of the death action, percentage has been changed to 0%");
        }
        return deathActionConfigBlock;
    }

    @Override
    public int getMinRange() {
        return (Integer)this.configRepository.getPropertyOrDefault("spawning.min-radius", 5);
    }

    @Override
    public int getMaxRange() {
        return (Integer)this.configRepository.getPropertyOrDefault("spawning.max-radius", 40);
    }

    @Override
    public int getMobsPerChunk() {
        return (Integer)this.configRepository.getPropertyOrDefault("spawning.mobs-per-chunk", 120);
    }

    @Override
    public boolean getSpawningEnabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("spawning.enabled", false);
    }

    @Override
    public boolean isLifeCycleMobProgressEnabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("lifecycles.mob-progress", true);
    }

    @Override
    public boolean longerNightsEnabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("nights.longer", false);
    }

    @Override
    public double nightsBoostPercentage() {
        return (Double)this.configRepository.getPropertyOrDefault("nights.boost-percentage", 20.0);
    }

    @Override
    public boolean darkerNightsEnabled() {
        return (Boolean)this.configRepository.getPropertyOrDefault("nights.darker", false);
    }

    @Override
    public double darkerNightsPercentage() {
        return (Double)this.configRepository.getPropertyOrDefault("nights.darker-percentage", 50.0);
    }

    @Override
    public int darkerNightsDuration() {
        return (Integer)this.configRepository.getPropertyOrDefault("nights.darker-duration", 2);
    }

    @Override
    public List<String> getDeathCommand() {
        return (List)this.configRepository.getPropertyOrDefault("death-actions.commands", new ArrayList());
    }

    @Override
    public String getBellSoundName() {
        return (String)this.configRepository.getPropertyOrDefault("bell-warning.sound", "BLOCK_BELL_USE");
    }

    @Override
    public int getStartNightTime() {
        return (Integer)this.configRepository.getPropertyOrDefault("time.night-start", 12500);
    }

    @Override
    public int getEndNightTime() {
        return (Integer)this.configRepository.getPropertyOrDefault("time.night-end", 23500);
    }
}

