/*
 * Decompiled with CFR 0.152.
 */
package me.mrgeneralq.bloodmoon.statics;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.DashAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.DeathAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.ExplodeAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.HealAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.InvisibleAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.LightningAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.MobReinforcementAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.MobTeleportAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.NoAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.PotionEffectAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.RespawnAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.ShieldAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.SoundAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.SpeakAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.StopAction;
import me.mrgeneralq.bloodmoon.actions.bloodmoon.SwapAction;
import me.mrgeneralq.bloodmoon.interfaces.ITabCompleteParent;
import me.mrgeneralq.bloodmoon.interfaces.actions.IBloodmoonAction;
import me.mrgeneralq.bloodmoon.interfaces.services.IBloodmoonService;
import me.mrgeneralq.bloodmoon.interfaces.services.IMobService;
import me.mrgeneralq.bloodmoon.interfaces.services.ISoundService;
import me.mrgeneralq.bloodmoon.statics.Bootstrapper;
import me.mrgeneralq.bloodmoon.statics.Haversine;
import me.mrgeneralq.bloodmoon.statics.Message;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Statics {
    public static final String RESOURCE_ID = "75095";
    public static final String SWAP_ACTION = "swap";
    public static String HEAL_ACTION = "heal";
    public static String LIGHTING_ACTION = "lightning";
    public static String REINFORCEMENTS_ACTION = "reinforcements";
    public static String TELEPORT_ACTION = "teleport";
    public static String STOP_ACTION = "stop-bloodmoon";
    public static String DEATH_ACTION = "instant-kill";
    public static String DASH_ACTION = "dash";
    public static String POTION_EFFECT_ACTION = "potion-effect";
    public static String SPEAK_ACTION = "speak";
    public static String SHIELD_ACTION = "shield";
    public static String RESPAWN_ACTION = "respawn";
    public static String EXPLODE_ACTION = "explode";
    public static String SOUND_ACTION = "play-sound";
    public static String INVISIBLE_ACTION = "vanish";
    public static String PATH_FINDER_NAME = "pathfinder";
    private static Bootstrapper bootstrapper = Bootstrapper.getBootstrapper();
    private static IBloodmoonService bloodmoonService = bootstrapper.getBloodmoonService();
    private static IMobService mobService = bootstrapper.getMobService();
    private static ISoundService soundSerivce = bootstrapper.getSoundService();

    public static Location getLocation(Location location, int n) {
        double d = Math.random() * 360.0;
        double d2 = Math.random() * (double)n;
        double d3 = Math.cos(d) * d2;
        double d4 = Math.sin(d) * d2;
        Location location2 = new Location(location.getWorld(), d3 + location.getX(), location.getY(), d4 + location.getZ());
        Block block = location2.getBlock();
        while (block.getType() != Material.AIR) {
            location2 = new Location(location2.getWorld(), location2.getX(), location2.getY() + 1.0, location2.getZ());
            block = location2.getBlock();
        }
        return location2;
    }

    public static IBloodmoonAction getAction(String string) {
        if (string == null) {
            return new NoAction();
        }
        if (string.equalsIgnoreCase(LIGHTING_ACTION)) {
            return new LightningAction();
        }
        if (string.equalsIgnoreCase(REINFORCEMENTS_ACTION)) {
            return new MobReinforcementAction(bloodmoonService, mobService);
        }
        if (string.equalsIgnoreCase(TELEPORT_ACTION)) {
            return new MobTeleportAction();
        }
        if (string.equalsIgnoreCase(STOP_ACTION)) {
            return new StopAction(bloodmoonService);
        }
        if (string.equalsIgnoreCase(DEATH_ACTION)) {
            return new DeathAction();
        }
        if (string.equalsIgnoreCase(HEAL_ACTION)) {
            return new HealAction();
        }
        if (string.equalsIgnoreCase(DASH_ACTION)) {
            return new DashAction();
        }
        if (string.equalsIgnoreCase(POTION_EFFECT_ACTION)) {
            return new PotionEffectAction();
        }
        if (string.equalsIgnoreCase(SWAP_ACTION)) {
            return new SwapAction();
        }
        if (string.equalsIgnoreCase(SPEAK_ACTION)) {
            return new SpeakAction();
        }
        if (string.equalsIgnoreCase(SHIELD_ACTION)) {
            return new ShieldAction(bloodmoonService, mobService);
        }
        if (string.equalsIgnoreCase(RESPAWN_ACTION)) {
            return new RespawnAction(mobService);
        }
        if (string.equalsIgnoreCase(EXPLODE_ACTION)) {
            return new ExplodeAction();
        }
        if (string.equalsIgnoreCase(SOUND_ACTION)) {
            return new SoundAction(soundSerivce);
        }
        if (string.equalsIgnoreCase(INVISIBLE_ACTION)) {
            return new InvisibleAction();
        }
        return new NoAction();
    }

    public String getHash(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        byte[] byArray = messageDigest.digest(string.getBytes(StandardCharsets.UTF_8));
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString();
    }

    public static EntityType getEntityType(String string) {
        EntityType entityType = null;
        try {
            entityType = EntityType.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return entityType;
    }

    public static void createShieldEffect(Location location) {
        double d = 0.0;
        for (int i = 0; i < 60; ++i) {
            Location location2 = location.clone().add(Math.cos(d += 0.19634954084936207), Math.random() * 2.0, Math.sin(d));
            location.getWorld().spawnParticle(Particle.valueOf((String)"DRIP_WATER"), location2, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void createRespawnEffect(Location location) {
        double d = 0.0;
        for (int i = 0; i < 60; ++i) {
            Location location2 = location.clone().add(Math.cos(d += 0.1308996938995747), Math.random() * 2.0, Math.sin(d));
            location.getWorld().spawnParticle(Particle.valueOf((String)"DRIP_LAVA"), location2, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void createExplosion(Location location) {
        double d = 0.0;
        for (int i = 0; i < 30; ++i) {
            Location location2 = location.clone().add(Math.cos(d += 0.19634954084936207), Math.random() * 2.0, Math.sin(d));
            location.getWorld().spawnParticle(Particle.valueOf((String)"EXPLOSION_NORMAL"), location2, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static int bigger(Entity entity, Entity entity2, double d, double d2) {
        double d3;
        double d4 = Haversine.distance(entity.getLocation().getX(), entity.getLocation().getZ(), d, d2);
        return d4 > (d3 = Haversine.distance(entity2.getLocation().getX(), entity2.getLocation().getZ(), d, d2)) ? 1 : -1;
    }

    public static double linearInterpolation(double d, double d2, double d3, double d4, double d5) {
        return d2 + (d5 - d) * ((d4 - d2) / (d3 - d));
    }

    public static void setPathFinderMeta(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(Message.getMessage("&aPathfinder"));
        itemMeta.setLore(Arrays.asList(Message.getMessage("&r&7Right click to display a path"), Message.getMessage("&r&7pointing in the direction of the boss."), "", Message.getMessage("&r&7Only usable with the correct permissions!")));
        itemStack.setItemMeta(itemMeta);
    }

    public static void resetCompass(Player player) {
        Location location = null;
        if (player == null) {
            return;
        }
        if (player.getBedSpawnLocation() != null) {
            location = player.getBedSpawnLocation();
        }
        if (location == null) {
            location = player.getWorld().getSpawnLocation();
        }
        if (location != player.getCompassTarget()) {
            player.setCompassTarget(location);
        }
    }

    public static class ActionList
    implements ITabCompleteParent {
        private List<String> actions = Arrays.asList("swap", HEAL_ACTION, LIGHTING_ACTION, REINFORCEMENTS_ACTION, TELEPORT_ACTION, STOP_ACTION, DEATH_ACTION, DASH_ACTION, POTION_EFFECT_ACTION, SPEAK_ACTION, SHIELD_ACTION, RESPAWN_ACTION, EXPLODE_ACTION, SOUND_ACTION, INVISIBLE_ACTION);

        @Override
        public Set<String> get() {
            return new HashSet<String>(this.actions);
        }
    }
}

