/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser;

import java.util.Locale;
import java.util.regex.Pattern;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.Configurable;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPClientConfig;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFileEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.CompositeFileEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.MVSFTPEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.MacOsPeterFTPEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.NTFTPEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.NetwareFTPEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.OS2FTPEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.OS400FTPEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.ParserInitializationException;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.UnixFTPEntryParser;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.VMSVersioningFTPEntryParser;

public class DefaultFTPFileEntryParserFactory
implements FTPFileEntryParserFactory {
    private static final String JAVA_IDENTIFIER = "\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*";
    private static final String JAVA_QUALIFIED_NAME = "(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*\\.)+\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*";
    private static final Pattern JAVA_QUALIFIED_NAME_PATTERN = Pattern.compile("(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*\\.)+\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*");

    public FTPFileEntryParser createFileEntryParser(String string) {
        if (string == null) {
            throw new ParserInitializationException("Parser key cannot be null");
        }
        return this.createFileEntryParser(string, null);
    }

    private FTPFileEntryParser createFileEntryParser(String string, FTPClientConfig fTPClientConfig) {
        Object object;
        FTPFileEntryParser fTPFileEntryParser = null;
        if (JAVA_QUALIFIED_NAME_PATTERN.matcher(string).matches()) {
            try {
                object = Class.forName(string);
                try {
                    fTPFileEntryParser = (FTPFileEntryParser)((Class)object).newInstance();
                }
                catch (ClassCastException classCastException) {
                    throw new ParserInitializationException(((Class)object).getName() + " does not implement the interface " + "me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFileEntryParser.", classCastException);
                }
                catch (Exception exception) {
                    throw new ParserInitializationException("Error initializing parser", exception);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    throw new ParserInitializationException("Error initializing parser", exceptionInInitializerError);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (fTPFileEntryParser == null) {
            object = string.toUpperCase(Locale.ENGLISH);
            if (((String)object).indexOf("UNIX") >= 0) {
                fTPFileEntryParser = new UnixFTPEntryParser(fTPClientConfig);
            } else if (((String)object).indexOf("VMS") >= 0) {
                fTPFileEntryParser = new VMSVersioningFTPEntryParser(fTPClientConfig);
            } else if (((String)object).indexOf("WINDOWS") >= 0) {
                fTPFileEntryParser = this.createNTFTPEntryParser(fTPClientConfig);
            } else if (((String)object).indexOf("OS/2") >= 0) {
                fTPFileEntryParser = new OS2FTPEntryParser(fTPClientConfig);
            } else if (((String)object).indexOf("OS/400") >= 0 || ((String)object).indexOf("AS/400") >= 0) {
                fTPFileEntryParser = this.createOS400FTPEntryParser(fTPClientConfig);
            } else if (((String)object).indexOf("MVS") >= 0) {
                fTPFileEntryParser = new MVSFTPEntryParser();
            } else if (((String)object).indexOf("NETWARE") >= 0) {
                fTPFileEntryParser = new NetwareFTPEntryParser(fTPClientConfig);
            } else if (((String)object).indexOf("MACOS PETER") >= 0) {
                fTPFileEntryParser = new MacOsPeterFTPEntryParser(fTPClientConfig);
            } else if (((String)object).indexOf("TYPE: L8") >= 0) {
                fTPFileEntryParser = new UnixFTPEntryParser(fTPClientConfig);
            } else {
                throw new ParserInitializationException("Unknown parser type: " + string);
            }
        }
        if (fTPFileEntryParser instanceof Configurable) {
            ((Configurable)((Object)fTPFileEntryParser)).configure(fTPClientConfig);
        }
        return fTPFileEntryParser;
    }

    public FTPFileEntryParser createFileEntryParser(FTPClientConfig fTPClientConfig) {
        String string = fTPClientConfig.getServerSystemKey();
        return this.createFileEntryParser(string, fTPClientConfig);
    }

    public FTPFileEntryParser createUnixFTPEntryParser() {
        return new UnixFTPEntryParser();
    }

    public FTPFileEntryParser createVMSVersioningFTPEntryParser() {
        return new VMSVersioningFTPEntryParser();
    }

    public FTPFileEntryParser createNetwareFTPEntryParser() {
        return new NetwareFTPEntryParser();
    }

    public FTPFileEntryParser createNTFTPEntryParser() {
        return this.createNTFTPEntryParser(null);
    }

    private FTPFileEntryParser createNTFTPEntryParser(FTPClientConfig fTPClientConfig) {
        if (fTPClientConfig != null && "WINDOWS".equals(fTPClientConfig.getServerSystemKey())) {
            return new NTFTPEntryParser(fTPClientConfig);
        }
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new NTFTPEntryParser(fTPClientConfig), new UnixFTPEntryParser(fTPClientConfig)});
    }

    public FTPFileEntryParser createOS2FTPEntryParser() {
        return new OS2FTPEntryParser();
    }

    public FTPFileEntryParser createOS400FTPEntryParser() {
        return this.createOS400FTPEntryParser(null);
    }

    private FTPFileEntryParser createOS400FTPEntryParser(FTPClientConfig fTPClientConfig) {
        if (fTPClientConfig != null && "OS/400".equals(fTPClientConfig.getServerSystemKey())) {
            return new OS400FTPEntryParser(fTPClientConfig);
        }
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new OS400FTPEntryParser(fTPClientConfig), new UnixFTPEntryParser(fTPClientConfig)});
    }

    public FTPFileEntryParser createMVSEntryParser() {
        return new MVSFTPEntryParser();
    }
}

