/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.Configurable;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPClientConfig;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.FTPTimestampParser;

public class FTPTimestampParserImpl
implements FTPTimestampParser,
Configurable {
    private SimpleDateFormat defaultDateFormat;
    private SimpleDateFormat recentDateFormat;
    private boolean lenientFutureDates = false;

    public FTPTimestampParserImpl() {
        this.setDefaultDateFormat("MMM d yyyy");
        this.setRecentDateFormat("MMM d HH:mm");
    }

    public Calendar parseTimestamp(String string) {
        Calendar calendar = Calendar.getInstance();
        return this.parseTimestamp(string, calendar);
    }

    public Calendar parseTimestamp(String string, Calendar calendar) {
        Object object;
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.setTimeZone(this.getServerTimeZone());
        Date date = null;
        if (this.recentDateFormat != null) {
            object = (Calendar)calendar.clone();
            ((Calendar)object).setTimeZone(this.getServerTimeZone());
            if (this.lenientFutureDates) {
                ((Calendar)object).add(5, 1);
            }
            String string2 = Integer.toString(((Calendar)object).get(1));
            String string3 = string + " " + string2;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.recentDateFormat.toPattern() + " yyyy", this.recentDateFormat.getDateFormatSymbols());
            simpleDateFormat.setLenient(false);
            simpleDateFormat.setTimeZone(this.recentDateFormat.getTimeZone());
            ParsePosition parsePosition = new ParsePosition(0);
            date = simpleDateFormat.parse(string3, parsePosition);
            if (date != null && parsePosition.getIndex() == string3.length()) {
                calendar2.setTime(date);
                if (calendar2.after(object)) {
                    calendar2.add(1, -1);
                }
                return calendar2;
            }
        }
        if ((date = this.defaultDateFormat.parse(string, (ParsePosition)(object = new ParsePosition(0)))) == null || ((ParsePosition)object).getIndex() != string.length()) {
            throw new ParseException("Timestamp '" + string + "' could not be parsed using a server time of " + calendar.getTime().toString(), ((ParsePosition)object).getErrorIndex());
        }
        calendar2.setTime(date);
        return calendar2;
    }

    public SimpleDateFormat getDefaultDateFormat() {
        return this.defaultDateFormat;
    }

    public String getDefaultDateFormatString() {
        return this.defaultDateFormat.toPattern();
    }

    private void setDefaultDateFormat(String string) {
        if (string != null) {
            this.defaultDateFormat = new SimpleDateFormat(string);
            this.defaultDateFormat.setLenient(false);
        }
    }

    public SimpleDateFormat getRecentDateFormat() {
        return this.recentDateFormat;
    }

    public String getRecentDateFormatString() {
        return this.recentDateFormat.toPattern();
    }

    private void setRecentDateFormat(String string) {
        if (string != null) {
            this.recentDateFormat = new SimpleDateFormat(string);
            this.recentDateFormat.setLenient(false);
        }
    }

    public String[] getShortMonths() {
        return this.defaultDateFormat.getDateFormatSymbols().getShortMonths();
    }

    public TimeZone getServerTimeZone() {
        return this.defaultDateFormat.getTimeZone();
    }

    private void setServerTimeZone(String string) {
        TimeZone timeZone = TimeZone.getDefault();
        if (string != null) {
            timeZone = TimeZone.getTimeZone(string);
        }
        this.defaultDateFormat.setTimeZone(timeZone);
        if (this.recentDateFormat != null) {
            this.recentDateFormat.setTimeZone(timeZone);
        }
    }

    public void configure(FTPClientConfig fTPClientConfig) {
        DateFormatSymbols dateFormatSymbols = null;
        String string = fTPClientConfig.getServerLanguageCode();
        String string2 = fTPClientConfig.getShortMonthNames();
        dateFormatSymbols = string2 != null ? FTPClientConfig.getDateFormatSymbols(string2) : (string != null ? FTPClientConfig.lookupDateFormatSymbols(string) : FTPClientConfig.lookupDateFormatSymbols("en"));
        String string3 = fTPClientConfig.getRecentDateFormatStr();
        if (string3 == null) {
            this.recentDateFormat = null;
        } else {
            this.recentDateFormat = new SimpleDateFormat(string3, dateFormatSymbols);
            this.recentDateFormat.setLenient(false);
        }
        String string4 = fTPClientConfig.getDefaultDateFormatStr();
        if (string4 == null) {
            throw new IllegalArgumentException("defaultFormatString cannot be null");
        }
        this.defaultDateFormat = new SimpleDateFormat(string4, dateFormatSymbols);
        this.defaultDateFormat.setLenient(false);
        this.setServerTimeZone(fTPClientConfig.getServerTimeZoneId());
        this.lenientFutureDates = fTPClientConfig.isLenientFutureDates();
    }

    boolean isLenientFutureDates() {
        return this.lenientFutureDates;
    }

    void setLenientFutureDates(boolean bl2) {
        this.lenientFutureDates = bl2;
    }
}

