/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser;

import java.io.BufferedReader;
import java.io.InputStream;
import java.text.ParseException;
import java.util.StringTokenizer;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPClientConfig;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPFile;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.FTPListParseEngine;
import me.forseth11.easybackup.dependencies.apache.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;

public class VMSFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static final String DEFAULT_DATE_FORMAT = "d-MMM-yyyy HH:mm:ss";
    private static final String REGEX = "(.*;[0-9]+)\\s*(\\d+)/\\d+\\s*(\\S+)\\s+(\\S+)\\s+\\[(([0-9$A-Za-z_]+)|([0-9$A-Za-z_]+),([0-9$a-zA-Z_]+))\\]?\\s*\\([a-zA-Z]*,([a-zA-Z]*),([a-zA-Z]*),([a-zA-Z]*)\\)";

    public VMSFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public VMSFTPEntryParser(FTPClientConfig fTPClientConfig) {
        super(REGEX);
        this.configure(fTPClientConfig);
    }

    public FTPFile parseFTPEntry(String string) {
        long l2 = 512L;
        if (this.matches(string)) {
            String string2;
            String string3;
            FTPFile fTPFile = new FTPFile();
            fTPFile.setRawListing(string);
            String string4 = this.group(1);
            String string5 = this.group(2);
            String string6 = this.group(3) + " " + this.group(4);
            String string7 = this.group(5);
            String[] stringArray = new String[]{this.group(9), this.group(10), this.group(11)};
            try {
                fTPFile.setTimestamp(super.parseTimestamp(string6));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
            switch (stringTokenizer.countTokens()) {
                case 1: {
                    string3 = null;
                    string2 = stringTokenizer.nextToken();
                    break;
                }
                case 2: {
                    string3 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    break;
                }
                default: {
                    string3 = null;
                    string2 = null;
                }
            }
            if (string4.lastIndexOf(".DIR") != -1) {
                fTPFile.setType(1);
            } else {
                fTPFile.setType(0);
            }
            if (this.isVersioning()) {
                fTPFile.setName(string4);
            } else {
                string4 = string4.substring(0, string4.lastIndexOf(";"));
                fTPFile.setName(string4);
            }
            long l3 = Long.parseLong(string5) * l2;
            fTPFile.setSize(l3);
            fTPFile.setGroup(string3);
            fTPFile.setUser(string2);
            for (int i2 = 0; i2 < 3; ++i2) {
                String string8 = stringArray[i2];
                fTPFile.setPermission(i2, 0, string8.indexOf(82) >= 0);
                fTPFile.setPermission(i2, 1, string8.indexOf(87) >= 0);
                fTPFile.setPermission(i2, 2, string8.indexOf(69) >= 0);
            }
            return fTPFile;
        }
        return null;
    }

    public String readNextEntry(BufferedReader bufferedReader) {
        String string = bufferedReader.readLine();
        StringBuilder stringBuilder = new StringBuilder();
        while (string != null) {
            if (string.startsWith("Directory") || string.startsWith("Total")) {
                string = bufferedReader.readLine();
                continue;
            }
            stringBuilder.append(string);
            if (string.trim().endsWith(")")) break;
            string = bufferedReader.readLine();
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    protected boolean isVersioning() {
        return false;
    }

    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("VMS", DEFAULT_DATE_FORMAT, null, null, null, null);
    }

    @Deprecated
    public FTPFile[] parseFileList(InputStream inputStream) {
        FTPListParseEngine fTPListParseEngine = new FTPListParseEngine(this);
        fTPListParseEngine.readServerList(inputStream, null);
        return fTPListParseEngine.getFiles();
    }
}

