/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.converter;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.forseth11.easybackup.dependencies.apache.commons.lang3.StringUtils;
import me.forseth11.easybackup.dependencies.sl4j.Logger;
import me.forseth11.easybackup.dependencies.sl4j.LoggerFactory;

public abstract class BaseCronTransformer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseCronTransformer.class);
    protected String[] cronParts;
    protected Calendar calendarInstance;
    protected Integer calendarField;
    protected int cronFieldPosition;
    protected Integer cronFieldValue;
    Map<Integer, Integer> CRON_FIELDS_POSITION_MAP = Collections.unmodifiableMap(new HashMap<Integer, Integer>(){
        private static final long serialVersionUID = 911848294809282617L;
        {
            this.put(0, 12);
            this.put(1, 11);
            this.put(2, 5);
            this.put(3, 2);
            this.put(4, 7);
        }
    });

    public void apply(String[] stringArray, Calendar calendar) {
        this.cronParts = stringArray;
        this.calendarInstance = calendar;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!StringUtils.isNumeric(stringArray[i2])) continue;
            this.calendarField = this.CRON_FIELDS_POSITION_MAP.get(i2);
            this.cronFieldPosition = i2;
            this.cronFieldValue = Integer.parseInt(stringArray[i2]);
            this.transform();
        }
    }

    protected abstract void transform();
}

