/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.converter;

import java.time.ZoneId;
import java.util.Calendar;
import java.util.TimeZone;
import me.forseth11.easybackup.dependencies.apache.commons.lang3.StringUtils;
import me.forseth11.easybackup.dependencies.cronutils.converter.CalendarToCronTransformer;
import me.forseth11.easybackup.dependencies.cronutils.converter.CronToCalendarTransformer;
import me.forseth11.easybackup.dependencies.sl4j.Logger;
import me.forseth11.easybackup.dependencies.sl4j.LoggerFactory;

public class CronConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CronConverter.class);
    private static final String CRON_FIELDS_SEPARATOR = " ";
    CronToCalendarTransformer toCalendarConverter = new CronToCalendarTransformer();
    CalendarToCronTransformer toCronConverter = new CalendarToCronTransformer();
    private String[] cronParts;
    private Calendar fromCalendar;
    private String sourceCron;
    private ZoneId sourceZoneId;
    private ZoneId targetZoneId;

    public CronConverter using(String string) {
        this.sourceCron = string;
        this.cronParts = string.split(CRON_FIELDS_SEPARATOR);
        LOGGER.debug("Cron '{}' split into {}", (Object)string, (Object)this.cronParts);
        return this;
    }

    public CronConverter from(ZoneId zoneId) {
        this.sourceZoneId = zoneId;
        this.fromCalendar = this.getCalendar(zoneId);
        this.toCalendarConverter.apply(this.cronParts, this.fromCalendar);
        LOGGER.debug("Calendar object built using cron :{} and zoneID {} => {}", this.cronParts, zoneId, this.fromCalendar);
        return this;
    }

    public CronConverter to(ZoneId zoneId) {
        this.targetZoneId = zoneId;
        Calendar calendar = this.getCalendar(zoneId);
        calendar.setTimeInMillis(this.fromCalendar.getTimeInMillis());
        LOGGER.debug("Calendar object built from calendar {} and zoneID {} => {}", this.fromCalendar, zoneId, calendar);
        this.toCronConverter.apply(this.cronParts, calendar);
        LOGGER.debug("cron after applying calendar {} => {}", (Object)calendar, (Object)this.cronParts);
        return this;
    }

    public String convert() {
        String string = StringUtils.join((Object[])this.cronParts, CRON_FIELDS_SEPARATOR);
        LOGGER.info("Converted CRON -- {} :[{}] => {} :[{}]", this.sourceZoneId, this.sourceCron, this.targetZoneId, string);
        return string;
    }

    private Calendar getCalendar(ZoneId zoneId) {
        return Calendar.getInstance(TimeZone.getTimeZone(zoneId));
    }

    public void setToCalendarConverter(CronToCalendarTransformer cronToCalendarTransformer) {
        this.toCalendarConverter = cronToCalendarTransformer;
    }

    public void setToCronConverter(CalendarToCronTransformer calendarToCronTransformer) {
        this.toCronConverter = calendarToCronTransformer;
    }
}

