/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.descriptor;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.Locale;
import me.forseth11.easybackup.dependencies.cronutils.Function;
import me.forseth11.easybackup.dependencies.cronutils.descriptor.DescriptionStrategy;
import me.forseth11.easybackup.dependencies.cronutils.descriptor.NominalDescriptionStrategy;
import me.forseth11.easybackup.dependencies.cronutils.descriptor.TimeDescriptionStrategy;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.definition.FieldDefinition;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.FieldExpression;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;

class DescriptionStrategyFactory {
    private DescriptionStrategyFactory() {
    }

    public static DescriptionStrategy daysOfWeekInstance(FieldExpression fieldExpression2, FieldDefinition fieldDefinition) {
        Function<Integer, String> function = n2 -> {
            int n3 = fieldDefinition instanceof DayOfWeekFieldDefinition ? DayOfWeek.MONDAY.getValue() - ((DayOfWeekFieldDefinition)fieldDefinition).getMondayDoWValue().getMondayDoWValue() : 0;
            return DayOfWeek.of(n2 + n3 < 1 ? 7 : n2 + n3).getDisplayName(TextStyle.FULL, Locale.UK);
        };
        NominalDescriptionStrategy nominalDescriptionStrategy = new NominalDescriptionStrategy(function, fieldExpression2);
        nominalDescriptionStrategy.addDescription(fieldExpression -> {
            if (fieldExpression instanceof On) {
                On on = (On)fieldExpression;
                switch (on.getSpecialChar().getValue()) {
                    case HASH: {
                        return String.format("%s %s %s ", function.apply(on.getTime().getValue()), on.getNth(), "of every month");
                    }
                    case L: {
                        return String.format("%s %s %s ", "last", function.apply(on.getTime().getValue()), "of every month");
                    }
                }
                return "";
            }
            return "";
        });
        return nominalDescriptionStrategy;
    }

    public static DescriptionStrategy daysOfMonthInstance(FieldExpression fieldExpression2) {
        NominalDescriptionStrategy nominalDescriptionStrategy = new NominalDescriptionStrategy(null, fieldExpression2);
        nominalDescriptionStrategy.addDescription(fieldExpression -> {
            if (fieldExpression instanceof On) {
                On on = (On)fieldExpression;
                switch (on.getSpecialChar().getValue()) {
                    case W: {
                        return String.format("%s %s %s ", "the nearest weekday to the", on.getTime().getValue(), "of the month");
                    }
                    case L: {
                        return "last day of month";
                    }
                    case LW: {
                        return "last weekday of month";
                    }
                }
                return "";
            }
            return "";
        });
        return nominalDescriptionStrategy;
    }

    public static DescriptionStrategy monthsInstance(FieldExpression fieldExpression) {
        return new NominalDescriptionStrategy(n2 -> Month.of(n2).getDisplayName(TextStyle.FULL, Locale.UK), fieldExpression);
    }

    public static DescriptionStrategy plainInstance(FieldExpression fieldExpression) {
        return new NominalDescriptionStrategy(null, fieldExpression);
    }

    public static DescriptionStrategy hhMMssInstance(FieldExpression fieldExpression, FieldExpression fieldExpression2, FieldExpression fieldExpression3) {
        return new TimeDescriptionStrategy(fieldExpression, fieldExpression2, fieldExpression3);
    }
}

