/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.descriptor.refactor;

import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import me.forseth11.easybackup.dependencies.cronutils.model.Cron;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronField;
import me.forseth11.easybackup.dependencies.cronutils.model.field.CronFieldName;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Always;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.Every;
import me.forseth11.easybackup.dependencies.cronutils.model.field.expression.On;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;

public class TimeDescriptor {
    private final ResourceBundle resourceBundle;

    public TimeDescriptor(ResourceBundle resourceBundle) {
        this.resourceBundle = Preconditions.checkNotNull(resourceBundle, "The resource bundle must not be null");
    }

    public String describe(Cron cron) {
        return this.describe(cron.retrieveFieldsAsMap());
    }

    private String describe(Map<CronFieldName, CronField> map) {
        if (map.containsKey((Object)CronFieldName.SECOND)) {
            CronField cronField = map.get((Object)CronFieldName.SECOND);
            if (cronField.getExpression() instanceof Always) {
                return this.describeEverySecond(1);
            }
            if (cronField.getExpression() instanceof On) {
                return this.describeAtSecond(((On)cronField.getExpression()).getTime().getValue());
            }
            if (cronField.getExpression() instanceof Every) {
                return this.describeEverySecond(((Every)cronField.getExpression()).getPeriod().getValue());
            }
        }
        return "";
    }

    private String describeEverySecond(int n2) {
        double[] dArray = new double[]{1.0, 2.0};
        String[] stringArray = new String[]{this.resourceBundle.getString("oneSecond"), this.resourceBundle.getString("multipleSeconds")};
        double[] dArray2 = new double[]{1.0, 2.0};
        String[] stringArray2 = new String[]{this.resourceBundle.getString("every_one"), this.resourceBundle.getString("every_multi")};
        ChoiceFormat choiceFormat = new ChoiceFormat(dArray, stringArray);
        ChoiceFormat choiceFormat2 = new ChoiceFormat(dArray2, stringArray2);
        String string = this.resourceBundle.getString("pattern_every_seconds");
        MessageFormat messageFormat = new MessageFormat(string, Locale.UK);
        Format[] formatArray = new Format[]{choiceFormat2, choiceFormat, NumberFormat.getInstance()};
        messageFormat.setFormats(formatArray);
        Object[] objectArray = new Object[]{n2, n2, n2};
        String string2 = messageFormat.format(objectArray);
        return string2;
    }

    private String describeAtSecond(int n2) {
        String string = this.resourceBundle.getString("pattern_at_second");
        MessageFormat messageFormat = new MessageFormat(string, Locale.UK);
        Format[] formatArray = new Format[]{NumberFormat.getInstance()};
        messageFormat.setFormats(formatArray);
        Object[] objectArray = new Object[]{n2};
        String string2 = messageFormat.format(objectArray);
        return string2;
    }
}

