/*
 * Decompiled with CFR 0.152.
 */
package me.forseth11.easybackup.dependencies.cronutils.mapper;

import java.io.Serializable;
import me.forseth11.easybackup.dependencies.cronutils.Function;
import me.forseth11.easybackup.dependencies.cronutils.utils.Preconditions;
import me.forseth11.easybackup.dependencies.cronutils.utils.VisibleForTesting;

@VisibleForTesting
public class WeekDay
implements Serializable {
    private static final long serialVersionUID = -1542525283511798919L;
    private final int mondayDoWValue;
    private final boolean firstDayZero;

    public WeekDay(int n2, boolean bl2) {
        Preconditions.checkArgument(n2 >= 0, "Monday Day of Week value must be greater or equal to zero");
        this.mondayDoWValue = n2;
        this.firstDayZero = bl2;
    }

    public int getMondayDoWValue() {
        return this.mondayDoWValue;
    }

    public boolean isFirstDayZero() {
        return this.firstDayZero;
    }

    public int mapTo(int n2, WeekDay weekDay) {
        if (this.firstDayZero && weekDay.isFirstDayZero()) {
            return this.bothSameStartOfRange(0, 6, this, weekDay).apply(n2);
        }
        if (!this.firstDayZero && !weekDay.isFirstDayZero()) {
            return this.bothSameStartOfRange(1, 7, this, weekDay).apply(n2);
        }
        if (weekDay.isFirstDayZero()) {
            return this.mapTo(n2, new WeekDay(weekDay.getMondayDoWValue() + 1, false)) - 1;
        }
        return this.mapTo(n2, new WeekDay(weekDay.getMondayDoWValue() - 1, true)) + 1;
    }

    private Function<Integer, Integer> bothSameStartOfRange(int n2, int n3, WeekDay weekDay, WeekDay weekDay2) {
        return n4 -> {
            int n5 = weekDay2.getMondayDoWValue() - weekDay.getMondayDoWValue();
            int n6 = n4;
            if (n5 == 0) {
                return n4;
            }
            if (n5 < 0) {
                n6 = n4 + n5;
                int n7 = n2 - n6;
                if (n6 < n2) {
                    n6 = n3 + 1 - n7;
                }
            }
            if (n5 > 0 && (n6 = n4 + n5) > n3) {
                n6 -= n3;
            }
            return n6;
        };
    }
}

